/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.deployer;

import java.util.Map;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.apache.commons.lang3.StringUtils;

public class ResourceNameUtil {
    public static final String[] BPMN_RESOURCE_SUFFIXES = new String[]{"bpmn20.xml", "bpmn"};
    public static final String[] DIAGRAM_SUFFIXES = new String[]{"png", "jpg", "gif", "svg"};

    public static String stripBpmnFileSuffix(String bpmnFileResource) {
        for (String suffix : BPMN_RESOURCE_SUFFIXES) {
            if (!bpmnFileResource.endsWith(suffix)) continue;
            return bpmnFileResource.substring(0, bpmnFileResource.length() - suffix.length());
        }
        return bpmnFileResource;
    }

    public static String getProcessDiagramResourceName(String bpmnFileResource, String processKey, String diagramSuffix) {
        String bpmnFileResourceBase = ResourceNameUtil.stripBpmnFileSuffix(bpmnFileResource);
        return bpmnFileResourceBase + processKey + "." + diagramSuffix;
    }

    public static String getProcessDiagramResourceNameFromDeployment(ProcessDefinitionEntity processDefinition, Map<String, ResourceEntity> resources) {
        if (StringUtils.isEmpty((CharSequence)processDefinition.getResourceName())) {
            throw new IllegalStateException("Provided process definition must have its resource name set.");
        }
        String bpmnResourceBase = ResourceNameUtil.stripBpmnFileSuffix(processDefinition.getResourceName());
        String key = processDefinition.getKey();
        for (String diagramSuffix : DIAGRAM_SUFFIXES) {
            String possibleName = bpmnResourceBase + key + "." + diagramSuffix;
            if (resources.containsKey(possibleName)) {
                return possibleName;
            }
            possibleName = bpmnResourceBase + diagramSuffix;
            if (!resources.containsKey(possibleName)) continue;
            return possibleName;
        }
        return null;
    }
}

