/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.activiti.engine.impl.variable.JsonTypeConverter;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonType
implements VariableType {
    private static final Logger logger = LoggerFactory.getLogger(JsonType.class);
    public static final String JSON = "json";
    private final int maxLength;
    private ObjectMapper objectMapper;
    private boolean serializePOJOsInVariablesToJson;
    private JsonTypeConverter jsonTypeConverter;

    public JsonType(int maxLength, ObjectMapper objectMapper, boolean serializePOJOsInVariablesToJson, JsonTypeConverter jsonTypeConverter) {
        this.maxLength = maxLength;
        this.objectMapper = objectMapper;
        this.serializePOJOsInVariablesToJson = serializePOJOsInVariablesToJson;
        this.jsonTypeConverter = jsonTypeConverter;
    }

    @Override
    public String getTypeName() {
        return JSON;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        Object loadedValue = null;
        if (valueFields.getTextValue() != null && valueFields.getTextValue().length() > 0) {
            try {
                loadedValue = this.jsonTypeConverter.convertToValue(this.objectMapper.readTree(valueFields.getTextValue()), valueFields);
            }
            catch (Exception e) {
                logger.error("Error reading json variable " + valueFields.getName(), (Throwable)e);
            }
        }
        return loadedValue;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        try {
            valueFields.setTextValue(this.objectMapper.writeValueAsString(value));
            if (value != null) {
                valueFields.setTextValue2(value.getClass().getName());
            }
        }
        catch (JsonProcessingException e) {
            logger.error("Error writing json variable " + valueFields.getName(), (Throwable)e);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (JsonNode.class.isAssignableFrom(value.getClass()) || this.objectMapper.canSerialize(value.getClass()) && this.serializePOJOsInVariablesToJson) {
            try {
                return this.objectMapper.writeValueAsString(value).length() <= this.maxLength;
            }
            catch (JsonProcessingException e) {
                logger.error("Error writing json variable of type " + String.valueOf(value.getClass()), (Throwable)e);
            }
        }
        return false;
    }
}

