/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.DelegateExecutionFunction;
import org.activiti.engine.impl.bpmn.behavior.DelegateExecutionOutcome;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.activiti.engine.impl.delegate.ActivityBehaviorInvocation;
import org.activiti.engine.impl.delegate.TriggerableActivityBehavior;
import org.activiti.engine.impl.delegate.invocation.JavaDelegateInvocation;
import org.apache.commons.lang3.StringUtils;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    private final List<FieldDeclaration> fieldDeclarations;

    public ServiceTaskDelegateExpressionActivityBehavior(String serviceTaskId, Expression expression, Expression skipExpression, List<FieldDeclaration> fieldDeclarations) {
        this.serviceTaskId = serviceTaskId;
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, execution, this.fieldDeclarations);
        if (delegate instanceof DelegateExecutionFunction) {
            this.leave(execution);
        } else if (delegate instanceof TriggerableActivityBehavior) {
            TriggerableActivityBehavior behavior = (TriggerableActivityBehavior)delegate;
            behavior.trigger(execution, signalName, signalData);
        }
    }

    @Override
    public void execute(DelegateExecution execution) {
        block13: {
            try {
                boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(execution, this.skipExpression);
                if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(execution, this.skipExpression)) {
                    Object delegate;
                    Object overrideExpression;
                    ObjectNode taskElementProperties;
                    if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (taskElementProperties = Context.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("serviceTaskDelegateExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = taskElementProperties.get("serviceTaskDelegateExpression").asText())) && !((String)overrideExpression).equals(this.expression.getExpressionText())) {
                        this.expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression((String)overrideExpression);
                    }
                    overrideExpression = delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, execution, this.fieldDeclarations);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DelegateExecutionFunction.class, ActivityBehavior.class, JavaDelegate.class}, (Object)overrideExpression, n)) {
                        case 0: {
                            DelegateExecutionFunction function = (DelegateExecutionFunction)overrideExpression;
                            DelegateExecutionOutcome outcome = (DelegateExecutionOutcome)((Object)function.apply(execution));
                            if (outcome == DelegateExecutionOutcome.LEAVE_EXECUTION) {
                                this.leave(execution);
                                break;
                            }
                            break block13;
                        }
                        case 1: {
                            ActivityBehavior activityBehavior = (ActivityBehavior)overrideExpression;
                            if (delegate instanceof AbstractBpmnActivityBehavior) {
                                AbstractBpmnActivityBehavior behavior = (AbstractBpmnActivityBehavior)delegate;
                                behavior.setMultiInstanceActivityBehavior(this.getMultiInstanceActivityBehavior());
                            }
                            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation(activityBehavior, execution));
                            break;
                        }
                        case 2: {
                            JavaDelegate javaDelegate = (JavaDelegate)overrideExpression;
                            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation(javaDelegate, execution));
                            this.leave(execution);
                            break;
                        }
                        default: {
                            throw new ActivitiIllegalArgumentException("The resolved delegate expression " + String.valueOf(this.expression) + " should be an implementation of one of " + String.valueOf(ActivityBehavior.class) + ", " + String.valueOf(JavaDelegate.class) + " or " + String.valueOf(DelegateExecutionFunction.class));
                        }
                    }
                    break block13;
                }
                this.leave(execution);
            }
            catch (Exception exc) {
                BpmnError error = null;
                for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof BpmnError)) continue;
                    error = (BpmnError)cause;
                    break;
                }
                if (error != null) {
                    ErrorPropagation.propagateError(error, execution);
                }
                throw new ActivitiException(exc.getMessage(), exc);
            }
        }
    }
}

