/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class LocalDateType
implements VariableType {
    @Override
    public String getTypeName() {
        return "localDate";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return LocalDate.class.isAssignableFrom(value.getClass());
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        Long longValue = valueFields.getLongValue();
        if (longValue != null) {
            LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(longValue, 0, ZoneOffset.UTC);
            return localDateTime.toLocalDate();
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            LocalDateTime localDateTime = ((LocalDate)value).atStartOfDay();
            valueFields.setLongValue(localDateTime.toEpochSecond(ZoneOffset.UTC));
        } else {
            valueFields.setLongValue(null);
        }
    }
}

