/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.db;

import java.util.Collections;
import java.util.List;

public class ActivitiVersion {
    protected String mainVersion;
    protected List<String> alternativeVersionStrings;

    public ActivitiVersion(String mainVersion) {
        this.mainVersion = mainVersion;
        this.alternativeVersionStrings = Collections.singletonList(mainVersion);
    }

    public ActivitiVersion(String mainVersion, List<String> alternativeVersionStrings) {
        this.mainVersion = mainVersion;
        this.alternativeVersionStrings = alternativeVersionStrings;
    }

    public String getMainVersion() {
        return this.mainVersion;
    }

    public boolean matches(String version) {
        if (version.equals(this.mainVersion)) {
            return true;
        }
        if (!this.alternativeVersionStrings.isEmpty()) {
            return this.alternativeVersionStrings.contains(version);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ActivitiVersion)) {
            return false;
        }
        ActivitiVersion other = (ActivitiVersion)obj;
        boolean mainVersionEqual = this.mainVersion.equals(other.mainVersion);
        if (!mainVersionEqual) {
            return false;
        }
        if (this.alternativeVersionStrings != null) {
            return this.alternativeVersionStrings.equals(other.alternativeVersionStrings);
        }
        return other.alternativeVersionStrings == null;
    }
}

