/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.delegate;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.delegate.MessagePayloadMappingProvider;

public class BpmnMessagePayloadMappingProvider
implements MessagePayloadMappingProvider {
    private final List<FieldDeclaration> fieldDeclarations;

    public BpmnMessagePayloadMappingProvider(List<FieldDeclaration> fieldDeclarations) {
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public Optional<Map<String, Object>> getMessagePayload(DelegateExecution execution) {
        LinkedHashMap payload = new LinkedHashMap();
        this.fieldDeclarations.stream().map(field -> this.applyFieldDeclaration(execution, (FieldDeclaration)field)).forEach(entry -> payload.put((String)entry.getKey(), entry.getValue()));
        return Optional.of(payload).filter(map -> !map.isEmpty()).map(map -> Collections.unmodifiableMap(map));
    }

    protected Map.Entry<String, Object> applyFieldDeclaration(DelegateExecution execution, FieldDeclaration field) {
        return Optional.of(field).map(f -> {
            Object value = Optional.ofNullable(f.getValue()).map(v -> Expression.class.isInstance(v) ? ((Expression)Expression.class.cast(v)).getValue(execution) : v).orElse(null);
            return new AbstractMap.SimpleImmutableEntry<String, Object>(field.getName(), value);
        }).get();
    }
}

