/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.delegate.event;

import java.util.ArrayList;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.apache.commons.lang3.StringUtils;

public enum ActivitiEventType {
    ENTITY_CREATED,
    ENTITY_INITIALIZED,
    ENTITY_UPDATED,
    ENTITY_DELETED,
    ENTITY_SUSPENDED,
    ENTITY_ACTIVATED,
    TIMER_SCHEDULED,
    TIMER_FIRED,
    JOB_CANCELED,
    JOB_EXECUTION_SUCCESS,
    JOB_EXECUTION_FAILURE,
    JOB_RETRIES_DECREMENTED,
    CUSTOM,
    ENGINE_CREATED,
    ENGINE_CLOSED,
    ACTIVITY_STARTED,
    ACTIVITY_COMPLETED,
    ACTIVITY_CANCELLED,
    ACTIVITY_SIGNALED,
    ACTIVITY_COMPENSATE,
    ACTIVITY_MESSAGE_SENT,
    ACTIVITY_MESSAGE_WAITING,
    ACTIVITY_MESSAGE_RECEIVED,
    ACTIVITY_ERROR_RECEIVED,
    HISTORIC_ACTIVITY_INSTANCE_CREATED,
    HISTORIC_ACTIVITY_INSTANCE_ENDED,
    SEQUENCEFLOW_TAKEN,
    UNCAUGHT_BPMN_ERROR,
    VARIABLE_CREATED,
    VARIABLE_UPDATED,
    VARIABLE_DELETED,
    TASK_CREATED,
    TASK_ASSIGNED,
    TASK_COMPLETED,
    PROCESS_STARTED,
    PROCESS_COMPLETED,
    PROCESS_COMPLETED_WITH_ERROR_END_EVENT,
    PROCESS_CANCELLED,
    HISTORIC_PROCESS_INSTANCE_CREATED,
    HISTORIC_PROCESS_INSTANCE_ENDED,
    MEMBERSHIP_CREATED,
    MEMBERSHIP_DELETED,
    MEMBERSHIPS_DELETED;

    public static final ActivitiEventType[] EMPTY_ARRAY;

    public static ActivitiEventType[] getTypesFromString(String string) {
        ArrayList<ActivitiEventType> result = new ArrayList<ActivitiEventType>();
        if (string != null && !string.isEmpty()) {
            String[] split;
            for (String typeName : split = StringUtils.split((String)string, (String)",")) {
                boolean found = false;
                for (ActivitiEventType type : ActivitiEventType.values()) {
                    if (!typeName.equals(type.name())) continue;
                    result.add(type);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new ActivitiIllegalArgumentException("Invalid event-type: " + typeName);
            }
        }
        return result.toArray(EMPTY_ARRAY);
    }

    static {
        EMPTY_ARRAY = new ActivitiEventType[0];
    }
}

