/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el.variable;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.el.variable.VariableScopeItemELResolver;
import org.activiti.engine.impl.persistence.entity.VariableInstance;

public class VariableElResolver
implements VariableScopeItemELResolver {
    private final ObjectMapper objectMapper;

    public VariableElResolver(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canResolve(String property, VariableScope variableScope) {
        return variableScope.hasVariable(property);
    }

    @Override
    public Object resolve(String property, VariableScope variableScope) {
        VariableInstance variableInstance = variableScope.getVariableInstance(property);
        Object value = variableInstance.getValue();
        if (this.hasJsonType(variableInstance) && value instanceof JsonNode && ((JsonNode)value).isArray()) {
            return this.objectMapper.convertValue(value, List.class);
        }
        return value;
    }

    private boolean hasJsonType(VariableInstance variableInstance) {
        return "json".equals(variableInstance.getTypeName()) || "longJson".equals(variableInstance.getTypeName());
    }
}

