/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.activiti.engine.impl.asyncexecutor.DefaultAsyncJobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedAsyncJobExecutor
extends DefaultAsyncJobExecutor {
    private static Logger log = LoggerFactory.getLogger(ManagedAsyncJobExecutor.class);
    protected ManagedThreadFactory threadFactory;

    public ManagedThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ManagedThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    protected void initAsyncJobExecutionThreadPool() {
        if (this.threadFactory == null) {
            log.warn("A managed thread factory was not found, falling back to self-managed threads");
            super.initAsyncJobExecutionThreadPool();
        } else {
            if (this.threadPoolQueue == null) {
                log.info("Creating thread pool queue of size {}", (Object)this.queueSize);
                this.threadPoolQueue = new ArrayBlockingQueue(this.queueSize);
            }
            if (this.executorService == null) {
                log.info("Creating executor service with corePoolSize {}, maxPoolSize {} and keepAliveTime {}", new Object[]{this.corePoolSize, this.maxPoolSize, this.keepAliveTime});
                ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.threadPoolQueue, (ThreadFactory)this.threadFactory);
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                this.executorService = threadPoolExecutor;
            }
            this.startJobAcquisitionThread();
        }
    }
}

