/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.delegate.event.impl;

import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.delegate.event.ActivitiEntityEvent;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventSupport;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.repository.ProcessDefinition;

public class ActivitiEventDispatcherImpl
implements ActivitiEventDispatcher {
    protected ActivitiEventSupport eventSupport = new ActivitiEventSupport();
    protected boolean enabled = true;

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void addEventListener(ActivitiEventListener listenerToAdd) {
        this.eventSupport.addEventListener(listenerToAdd);
    }

    @Override
    public void addEventListener(ActivitiEventListener listenerToAdd, ActivitiEventType ... types) {
        this.eventSupport.addEventListener(listenerToAdd, types);
    }

    @Override
    public void removeEventListener(ActivitiEventListener listenerToRemove) {
        this.eventSupport.removeEventListener(listenerToRemove);
    }

    @Override
    public void dispatchEvent(ActivitiEvent event) {
        BpmnModel bpmnModel;
        ActivitiEntityEvent entityEvent;
        if (this.enabled) {
            this.eventSupport.dispatchEvent(event);
        }
        if (event.getType() == ActivitiEventType.ENTITY_DELETED && event instanceof ActivitiEntityEvent && (entityEvent = (ActivitiEntityEvent)event).getEntity() instanceof ProcessDefinition) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null && (bpmnModel = this.extractBpmnModelFromEvent(event)) != null) {
            ((ActivitiEventSupport)bpmnModel.getEventSupport()).dispatchEvent(event);
        }
    }

    protected BpmnModel extractBpmnModelFromEvent(ActivitiEvent event) {
        ProcessDefinition processDefinition;
        BpmnModel result = null;
        if (result == null && event.getProcessDefinitionId() != null && (processDefinition = ProcessDefinitionUtil.getProcessDefinition(event.getProcessDefinitionId(), true)) != null) {
            result = Context.getProcessEngineConfiguration().getDeploymentManager().resolveProcessDefinition(processDefinition).getBpmnModel();
        }
        return result;
    }
}

