/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity.data.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.CachedEntityMatcher;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityImpl;
import org.activiti.engine.impl.persistence.entity.data.AbstractDataManager;
import org.activiti.engine.impl.persistence.entity.data.TaskDataManager;
import org.activiti.engine.impl.persistence.entity.data.impl.cachematcher.TasksByExecutionIdMatcher;
import org.activiti.engine.task.Task;

public class MybatisTaskDataManager
extends AbstractDataManager<TaskEntity>
implements TaskDataManager {
    protected CachedEntityMatcher<TaskEntity> tasksByExecutionIdMatcher = new TasksByExecutionIdMatcher();

    public MybatisTaskDataManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends TaskEntity> getManagedEntityClass() {
        return TaskEntityImpl.class;
    }

    @Override
    public TaskEntity create() {
        return new TaskEntityImpl();
    }

    @Override
    public List<TaskEntity> findTasksByExecutionId(String executionId) {
        return this.getList("selectTasksByExecutionId", executionId, this.tasksByExecutionIdMatcher, true);
    }

    @Override
    public List<TaskEntity> findTasksByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectTasksByProcessInstanceId", processInstanceId);
    }

    @Override
    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery) {
        String query = "selectTaskByQueryCriteria";
        return this.getDbSqlSession().selectList("selectTaskByQueryCriteria", taskQuery);
    }

    @Override
    public List<Task> findTasksAndVariablesByQueryCriteria(TaskQueryImpl taskQuery) {
        String query = "selectTaskWithVariablesByQueryCriteria";
        if (taskQuery.getFirstResult() < 0 || taskQuery.getMaxResults() <= 0) {
            return Collections.emptyList();
        }
        int firstResult = taskQuery.getFirstResult();
        int maxResults = taskQuery.getMaxResults();
        if (taskQuery.getTaskVariablesLimit() != null) {
            taskQuery.setMaxResults(taskQuery.getTaskVariablesLimit());
        } else {
            taskQuery.setMaxResults(this.getProcessEngineConfiguration().getTaskQueryLimit());
        }
        taskQuery.setFirstResult(0);
        List instanceList = this.getDbSqlSession().selectListWithRawParameterWithoutFilter("selectTaskWithVariablesByQueryCriteria", taskQuery, taskQuery.getFirstResult(), taskQuery.getMaxResults());
        if (instanceList != null && !instanceList.isEmpty()) {
            if (firstResult > 0) {
                if (firstResult <= instanceList.size()) {
                    int toIndex = firstResult + Math.min(maxResults, instanceList.size() - firstResult);
                    return instanceList.subList(firstResult, toIndex);
                }
                return Collections.emptyList();
            }
            int toIndex = Math.min(maxResults, instanceList.size());
            return instanceList.subList(0, toIndex);
        }
        return Collections.emptyList();
    }

    @Override
    public long findTaskCountByQueryCriteria(TaskQueryImpl taskQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByQueryCriteria", taskQuery);
    }

    @Override
    public List<Task> findTasksByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectTaskByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findTaskCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByNativeQuery", parameterMap);
    }

    @Override
    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return this.getDbSqlSession().selectList("selectTasksByParentTaskId", parentTaskId);
    }

    @Override
    public void updateTaskTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateTaskTenantIdForDeployment", params);
    }
}

