/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.test;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.cfg.CommandExecutorImpl;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.interceptor.CommandInterceptor;
import org.activiti.engine.impl.interceptor.CommandInvoker;
import org.activiti.engine.impl.interceptor.DebugCommandInvoker;
import org.activiti.engine.impl.interceptor.RetryInterceptor;
import org.activiti.engine.impl.test.AbstractActivitiTestCase;
import org.activiti.engine.test.EnableVerboseExecutionTreeLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluggableActivitiTestCase
extends AbstractActivitiTestCase {
    private static Logger pluggableActivitiTestCaseLogger = LoggerFactory.getLogger(PluggableActivitiTestCase.class);
    protected static ProcessEngine cachedProcessEngine;

    @Override
    protected void initializeProcessEngine() {
        if (cachedProcessEngine == null) {
            pluggableActivitiTestCaseLogger.info("No cached process engine found for test. Retrieving the default engine.");
            ProcessEngines.destroy();
            cachedProcessEngine = ProcessEngines.getDefaultProcessEngine();
            if (cachedProcessEngine == null) {
                throw new ActivitiException("no default process engine available");
            }
        }
        this.processEngine = cachedProcessEngine;
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        if (((Object)((Object)this)).getClass().isAnnotationPresent(EnableVerboseExecutionTreeLogging.class)) {
            this.swapCommandInvoker(true);
        }
    }

    @Override
    protected void closeDownProcessEngine() {
        super.closeDownProcessEngine();
        if (((Object)((Object)this)).getClass().isAnnotationPresent(EnableVerboseExecutionTreeLogging.class)) {
            this.swapCommandInvoker(false);
        }
    }

    protected void swapCommandInvoker(boolean debug) {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutor();
        if (commandExecutor instanceof CommandExecutorImpl) {
            CommandExecutorImpl commandExecutorImpl = (CommandExecutorImpl)commandExecutor;
            CommandInterceptor previousCommandInterceptor = null;
            for (CommandInterceptor commandInterceptor = commandExecutorImpl.getFirst(); commandInterceptor != null; commandInterceptor = commandInterceptor.getNext()) {
                boolean matches;
                boolean bl = matches = debug ? commandInterceptor instanceof CommandInvoker : commandInterceptor instanceof DebugCommandInvoker;
                if (matches) {
                    CommandInvoker commandInvoker;
                    CommandInvoker commandInvoker2 = commandInvoker = debug ? new DebugCommandInvoker() : new CommandInvoker();
                    if (previousCommandInterceptor != null) {
                        previousCommandInterceptor.setNext(commandInvoker);
                    } else {
                        commandExecutorImpl.setFirst(previousCommandInterceptor);
                    }
                    break;
                }
                previousCommandInterceptor = commandInterceptor;
            }
        } else {
            pluggableActivitiTestCaseLogger.warn("Not using " + String.valueOf(CommandExecutorImpl.class) + ", ignoring the " + String.valueOf(EnableVerboseExecutionTreeLogging.class) + " annotation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withRetryInterceptor(Runnable runnable) {
        CommandExecutorImpl commandExecutor = (CommandExecutorImpl)CommandExecutorImpl.class.cast(this.processEngineConfiguration.getCommandExecutor());
        CommandInterceptor original = commandExecutor.getFirst();
        try {
            RetryInterceptor retryInterceptor = new RetryInterceptor();
            retryInterceptor.setNext(original);
            commandExecutor.setFirst(retryInterceptor);
            runnable.run();
        }
        finally {
            commandExecutor.setFirst(original);
        }
    }
}

