/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.ProcessEngineInfo;
import org.activiti.engine.impl.ProcessEngineInfoImpl;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessEngines {
    private static Logger log = LoggerFactory.getLogger(ProcessEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, ProcessEngine> processEngines;
    protected static Map<String, ProcessEngineInfo> processEngineInfosByName;
    protected static Map<String, ProcessEngineInfo> processEngineInfosByResourceUrl;
    protected static List<ProcessEngineInfo> processEngineInfos;

    public static synchronized void init() {
        if (!ProcessEngines.isInitialized()) {
            if (processEngines == null) {
                processEngines = new HashMap<String, ProcessEngine>();
            }
            ClassLoader classLoader = ReflectUtil.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("activiti.cfg.xml");
            }
            catch (IOException e) {
                throw new ActivitiIllegalArgumentException("problem retrieving activiti.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                log.info("Initializing process engine using configuration '{}'", (Object)resource.toString());
                ProcessEngines.initProcessEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("activiti-context.xml");
            }
            catch (IOException e) {
                throw new ActivitiIllegalArgumentException("problem retrieving activiti-context.xml resources on the classpath: " + System.getProperty("java.class.path"), e);
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                log.info("Initializing process engine using Spring configuration '{}'", (Object)resource.toString());
                ProcessEngines.initProcessEngineFromSpringResource(resource);
            }
            ProcessEngines.setInitialized(true);
        } else {
            log.info("Process engines already initialized");
        }
    }

    protected static void initProcessEngineFromSpringResource(URL resource) {
        try {
            Class<?> springConfigurationHelperClass = ReflectUtil.loadClass("org.activiti.spring.SpringConfigurationHelper");
            Method method = springConfigurationHelperClass.getDeclaredMethod("buildProcessEngine", URL.class);
            ProcessEngine processEngine = (ProcessEngine)method.invoke(null, resource);
            String processEngineName = processEngine.getName();
            ProcessEngineInfoImpl processEngineInfo = new ProcessEngineInfoImpl(processEngineName, resource.toString(), null);
            processEngineInfosByName.put(processEngineName, processEngineInfo);
            processEngineInfosByResourceUrl.put(resource.toString(), processEngineInfo);
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't initialize process engine from spring configuration resource " + resource.toString() + ": " + e.getMessage(), e);
        }
    }

    public static void registerProcessEngine(ProcessEngine processEngine) {
        processEngines.put(processEngine.getName(), processEngine);
    }

    public static void unregister(ProcessEngine processEngine) {
        processEngines.remove(processEngine.getName());
    }

    private static ProcessEngineInfo initProcessEngineFromResource(URL resourceUrl) {
        ProcessEngineInfo processEngineInfo = processEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (processEngineInfo != null) {
            processEngineInfos.remove(processEngineInfo);
            if (processEngineInfo.getException() == null) {
                String processEngineName = processEngineInfo.getName();
                processEngines.remove(processEngineName);
                processEngineInfosByName.remove(processEngineName);
            }
            processEngineInfosByResourceUrl.remove(processEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            log.info("initializing process engine for resource {}", (Object)resourceUrl);
            ProcessEngine processEngine = ProcessEngines.buildProcessEngine(resourceUrl);
            String processEngineName = processEngine.getName();
            log.info("initialised process engine {}", (Object)processEngineName);
            processEngineInfo = new ProcessEngineInfoImpl(processEngineName, resourceUrlString, null);
            processEngines.put(processEngineName, processEngine);
            processEngineInfosByName.put(processEngineName, processEngineInfo);
        }
        catch (Throwable e) {
            log.error("Exception while initializing process engine: {}", (Object)e.getMessage(), (Object)e);
            processEngineInfo = new ProcessEngineInfoImpl(null, resourceUrlString, ProcessEngines.getExceptionString(e));
        }
        processEngineInfosByResourceUrl.put(resourceUrlString, processEngineInfo);
        processEngineInfos.add(processEngineInfo);
        return processEngineInfo;
    }

    private static String getExceptionString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private static ProcessEngine buildProcessEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            ProcessEngineConfiguration processEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromInputStream(inputStream);
            ProcessEngine processEngine = processEngineConfiguration.buildProcessEngine();
            return processEngine;
        }
        catch (IOException e) {
            throw new ActivitiIllegalArgumentException("couldn't open resource stream: " + e.getMessage(), e);
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    public static List<ProcessEngineInfo> getProcessEngineInfos() {
        return processEngineInfos;
    }

    public static ProcessEngineInfo getProcessEngineInfo(String processEngineName) {
        return processEngineInfosByName.get(processEngineName);
    }

    public static ProcessEngine getDefaultProcessEngine() {
        return ProcessEngines.getProcessEngine(NAME_DEFAULT);
    }

    public static ProcessEngine getProcessEngine(String processEngineName) {
        if (!ProcessEngines.isInitialized()) {
            ProcessEngines.init();
        }
        return processEngines.get(processEngineName);
    }

    public static ProcessEngineInfo retry(String resourceUrl) {
        log.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return ProcessEngines.initProcessEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new ActivitiIllegalArgumentException("invalid url: " + resourceUrl, e);
        }
    }

    public static Map<String, ProcessEngine> getProcessEngines() {
        return processEngines;
    }

    public static synchronized void destroy() {
        if (ProcessEngines.isInitialized()) {
            HashMap<String, ProcessEngine> engines = new HashMap<String, ProcessEngine>(processEngines);
            processEngines = new HashMap<String, ProcessEngine>();
            for (String processEngineName : engines.keySet()) {
                ProcessEngine processEngine = (ProcessEngine)engines.get(processEngineName);
                try {
                    processEngine.close();
                }
                catch (Exception e) {
                    log.error("exception while closing {}", processEngineName == null ? "the default process engine" : "process engine " + processEngineName, (Object)e);
                }
            }
            processEngineInfosByName.clear();
            processEngineInfosByResourceUrl.clear();
            processEngineInfos.clear();
            ProcessEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        ProcessEngines.isInitialized = isInitialized;
    }

    static {
        processEngines = new HashMap<String, ProcessEngine>();
        processEngineInfosByName = new HashMap<String, ProcessEngineInfo>();
        processEngineInfosByResourceUrl = new HashMap<String, ProcessEngineInfo>();
        processEngineInfos = new ArrayList<ProcessEngineInfo>();
    }
}

