/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IOParameter;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.NoneVariablesCalculator;
import org.activiti.engine.impl.bpmn.behavior.VariablesPropagator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.SubProcessActivityBehavior;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.StringUtils;

public class CallActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected Expression processDefinitionExpression;
    protected List<MapExceptionEntry> mapExceptions;
    private final VariablesPropagator variablesPropagator;

    public CallActivityBehavior(String processDefinitionKey, List<MapExceptionEntry> mapExceptions) {
        this(processDefinitionKey, mapExceptions, new VariablesPropagator(new NoneVariablesCalculator()));
    }

    public CallActivityBehavior(String processDefinitionKey, List<MapExceptionEntry> mapExceptions, VariablesPropagator variablesPropagator) {
        this.processDefinitionKey = processDefinitionKey;
        this.mapExceptions = mapExceptions;
        this.variablesPropagator = variablesPropagator;
    }

    public CallActivityBehavior(Expression processDefinitionExpression, List<MapExceptionEntry> mapExceptions) {
        this(processDefinitionExpression, mapExceptions, new VariablesPropagator(new NoneVariablesCalculator()));
    }

    public CallActivityBehavior(Expression processDefinitionExpression, List<MapExceptionEntry> mapExceptions, VariablesPropagator variablesPropagator) {
        this.processDefinitionExpression = processDefinitionExpression;
        this.mapExceptions = mapExceptions;
        this.variablesPropagator = variablesPropagator;
    }

    @Override
    public void execute(DelegateExecution execution) {
        String finalProcessDefinitionKey = this.resolveProcessDefinitionKey(execution);
        ProcessDefinition processDefinition = this.findProcessDefinition(finalProcessDefinitionKey, execution.getTenantId());
        Process subProcess = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        if (subProcess == null) {
            throw new ActivitiException("Cannot start a sub process instance. Process model " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") could not be found");
        }
        FlowElement initialFlowElement = subProcess.getInitialFlowElement();
        if (initialFlowElement == null) {
            throw new ActivitiException("No start element found for process definition " + processDefinition.getId());
        }
        if (ProcessDefinitionUtil.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new ActivitiException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CallActivity callActivity = (CallActivity)executionEntity.getCurrentFlowElement();
        String businessKey = null;
        if (!StringUtils.isEmpty((CharSequence)callActivity.getBusinessKey())) {
            Expression expression = expressionManager.createExpression(callActivity.getBusinessKey());
            businessKey = expression.getValue(execution).toString();
        } else if (callActivity.isInheritBusinessKey()) {
            ExecutionEntity processInstance = (ExecutionEntity)executionEntityManager.findById(execution.getProcessInstanceId());
            businessKey = processInstance.getBusinessKey();
        }
        ExecutionEntity subProcessInstance = Context.getCommandContext().getExecutionEntityManager().createSubprocessInstance(processDefinition, executionEntity, businessKey);
        Context.getCommandContext().getHistoryManager().recordSubProcessInstanceStart(executionEntity, subProcessInstance, initialFlowElement);
        Map<String, Object> variables = this.processDataObjects(subProcess.getDataObjects());
        if (callActivity.isInheritVariables()) {
            Map<String, Object> executionVariables = execution.getVariables();
            for (Map.Entry<String, Object> entry : executionVariables.entrySet()) {
                variables.put(entry.getKey(), entry.getValue());
            }
        }
        Map<String, Object> variablesFromExtensionFile = this.calculateInboundVariables(execution, processDefinition);
        variables.putAll(variablesFromExtensionFile);
        variables = this.copyProcessVariables(execution, expressionManager, callActivity, variables);
        if (!variables.isEmpty()) {
            this.initializeVariables(subProcessInstance, variables);
        }
        ExecutionEntity subProcessInitialExecution = executionEntityManager.createChildExecution(subProcessInstance);
        subProcessInitialExecution.setCurrentFlowElement(initialFlowElement);
        Context.getAgenda().planContinueProcessOperation(subProcessInitialExecution);
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createProcessStartedEvent(subProcessInitialExecution, variables, false));
    }

    private String resolveProcessDefinitionKey(DelegateExecution execution) {
        String finalProcessDefinitionKey = this.processDefinitionExpression != null ? (String)this.processDefinitionExpression.getValue(execution) : this.processDefinitionKey;
        return finalProcessDefinitionKey;
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        this.copyOutParameters(execution, subProcessInstance);
        this.variablesPropagator.propagate(execution, subProcessInstance.getVariables());
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
        this.leave(execution);
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    protected ProcessDefinition findProcessDefinition(String processDefinitionKey, String tenantId) {
        if (tenantId == null || "".equals(tenantId)) {
            return Context.getProcessEngineConfiguration().getDeploymentManager().findDeployedLatestProcessDefinitionByKey(processDefinitionKey);
        }
        return Context.getProcessEngineConfiguration().getDeploymentManager().findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            variablesMap = new HashMap(dataObjects.size());
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    protected void initializeVariables(ExecutionEntity subProcessInstance, Map<String, Object> variables) {
        subProcessInstance.setVariables(variables);
    }

    protected Map<String, Object> calculateInboundVariables(DelegateExecution execution, ProcessDefinition processDefinition) {
        return new HashMap<String, Object>();
    }

    protected Map<String, Object> copyProcessVariables(DelegateExecution execution, ExpressionManager expressionManager, CallActivity callActivity, Map<String, Object> variables) {
        for (IOParameter ioParameter : callActivity.getInParameters()) {
            Object value = null;
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                Expression expression = expressionManager.createExpression(ioParameter.getSourceExpression().trim());
                value = expression.getValue(execution);
            } else {
                value = execution.getVariable(ioParameter.getSource());
            }
            variables.put(ioParameter.getTarget(), value);
        }
        return variables;
    }

    protected DelegateExecution copyOutParameters(DelegateExecution execution, DelegateExecution subProcessInstance) {
        ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CallActivity callActivity = (CallActivity)executionEntity.getCurrentFlowElement();
        for (IOParameter ioParameter : callActivity.getOutParameters()) {
            Object value = null;
            if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                Expression expression = expressionManager.createExpression(ioParameter.getSourceExpression().trim());
                value = expression.getValue(subProcessInstance);
            } else {
                value = subProcessInstance.getVariable(ioParameter.getSource());
            }
            execution.setVariable(ioParameter.getTarget(), value);
        }
        return execution;
    }
}

