/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceBuilder;

public class ProcessInstanceBuilderImpl
implements ProcessInstanceBuilder {
    protected RuntimeServiceImpl runtimeService;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String messageName;
    protected String processInstanceName;
    protected String businessKey;
    protected String tenantId;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    private String linkedProcessInstanceId;
    private String linkedProcessInstanceType;

    public ProcessInstanceBuilderImpl(RuntimeServiceImpl runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Override
    public ProcessInstanceBuilder processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public ProcessInstanceBuilder messageName(String messageName) {
        this.messageName = messageName;
        return this;
    }

    @Override
    public ProcessInstanceBuilder name(String processInstanceName) {
        this.processInstanceName = processInstanceName;
        return this;
    }

    @Override
    public ProcessInstanceBuilder businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public ProcessInstanceBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder variables(Map<String, Object> variables) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.variables.put(variableName, variables.get(variableName));
            }
        }
        return this;
    }

    @Override
    public ProcessInstanceBuilder variable(String variableName, Object value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(variableName, value);
        return this;
    }

    @Override
    public ProcessInstanceBuilder transientVariables(Map<String, Object> transientVariables) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        if (transientVariables != null) {
            for (String variableName : transientVariables.keySet()) {
                this.transientVariables.put(variableName, transientVariables.get(variableName));
            }
        }
        return this;
    }

    @Override
    public ProcessInstanceBuilder transientVariable(String variableName, Object value) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        this.transientVariables.put(variableName, value);
        return this;
    }

    @Override
    public ProcessInstanceBuilder linkedProcessInstanceId(String linkedProcessInstanceId) {
        this.linkedProcessInstanceId = linkedProcessInstanceId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder linkedProcessInstanceType(String linkedProcessInstanceType) {
        this.linkedProcessInstanceType = linkedProcessInstanceType;
        return this;
    }

    public boolean hasProcessDefinitionIdOrKey() {
        return this.getProcessDefinitionId() != null || this.getProcessDefinitionKey() != null;
    }

    @Override
    public ProcessInstance start() {
        return this.runtimeService.startProcessInstance(this);
    }

    @Override
    public ProcessInstance create() {
        return this.runtimeService.createProcessInstance(this);
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public String getProcessInstanceName() {
        return this.processInstanceName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getLinkedProcessInstanceId() {
        return this.linkedProcessInstanceId;
    }

    public String getLinkedProcessInstanceType() {
        return this.linkedProcessInstanceType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, Object> getTransientVariables() {
        return this.transientVariables;
    }
}

