alter table ACT_RU_IDENTITYLINK drop FOREIGN KEY ACT_FK_TSKASS_TASK;
SET @sql = (
  SELECT IF(
    EXISTS(
      SELECT 1
      FROM INFORMATION_SCHEMA.STATISTICS
      WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'ACT_RU_IDENTITYLINK'
        AND INDEX_NAME = 'ACT_IDX_IDENT_LNK_TASK'
    ),
    'DROP INDEX ACT_IDX_IDENT_LNK_TASK ON ACT_RU_IDENTITYLINK',
    'DO 0'
  )
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

create index ACT_IDX_IDENT_LNK_TASK on ACT_RU_IDENTITYLINK(TASK_ID_ ASC);
ALTER TABLE ACT_RU_IDENTITYLINK ADD CONSTRAINT ACT_FK_TSKASS_TASK FOREIGN KEY (TASK_ID_) REFERENCES ACT_RU_TASK(ID_);


SET @sql = (
  SELECT IF(
    EXISTS(
      SELECT 1
      FROM INFORMATION_SCHEMA.STATISTICS
      WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME = 'ACT_RE_PROCDEF'
        AND INDEX_NAME = 'ACT_IDX_RE_PROCDEF_DEPLOYMENT_ID'
    ),
    'DROP INDEX ACT_IDX_RE_PROCDEF_DEPLOYMENT_ID ON ACT_RE_PROCDEF',
    'DO 0'
  )
);

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

create index ACT_IDX_RE_PROCDEF_DEPLOYMENT_ID on ACT_RE_PROCDEF(DEPLOYMENT_ID_ ASC, ID_ ASC);

update ACT_GE_PROPERTY set VALUE_ = '8.1.4' where NAME_ = 'schema.version';
