/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.Error;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.CollectionUtil;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.apache.commons.lang3.StringUtils;

public class ErrorPropagation {
    public static void propagateError(BpmnError error, DelegateExecution execution) {
        ErrorPropagation.propagateError(error.getErrorCode(), execution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propagateError(String errorRef, DelegateExecution execution) {
        boolean isCatchExecutedForProcess = false;
        boolean isCatchExecutedForCallActivity = false;
        try {
            Map<String, List<Event>> eventMap = ErrorPropagation.findCatchingEventsForProcess(execution.getProcessDefinitionId(), new Error(errorRef));
            if (!eventMap.isEmpty()) {
                isCatchExecutedForProcess = ErrorPropagation.executeCatch(eventMap, execution, new Error(errorRef));
            }
            if (!isCatchExecutedForProcess && ErrorPropagation.isCallActivity(execution)) {
                isCatchExecutedForCallActivity = ErrorPropagation.findCatchingEventsAndExecuteCatchForCallActivity(errorRef, execution);
            }
        }
        finally {
            if (!isCatchExecutedForProcess && !isCatchExecutedForCallActivity) {
                throw new BpmnError(errorRef, "No catching boundary event found for error with errorCode '" + errorRef + "', neither in same process nor in parent process");
            }
        }
    }

    protected static boolean executeCatch(Map<String, List<Event>> eventMap, DelegateExecution delegateExecution, Error error) {
        Event matchingEvent = null;
        ExecutionEntity currentExecution = (ExecutionEntity)delegateExecution;
        ExecutionEntity parentExecution = null;
        if (eventMap.containsKey(currentExecution.getActivityId())) {
            matchingEvent = eventMap.get(currentExecution.getActivityId()).get(0);
            parentExecution = currentExecution.getParentId() != null && currentExecution.getParent().isMultiInstanceRoot() ? currentExecution.getParent() : currentExecution;
        } else {
            parentExecution = currentExecution.getParent();
            while (matchingEvent == null && parentExecution != null) {
                FlowElementsContainer currentContainer = null;
                if (parentExecution.getCurrentFlowElement() instanceof FlowElementsContainer) {
                    currentContainer = (FlowElementsContainer)parentExecution.getCurrentFlowElement();
                } else if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                    currentContainer = ProcessDefinitionUtil.getProcess(parentExecution.getProcessDefinitionId());
                }
                for (String refId : eventMap.keySet()) {
                    List<Event> events = eventMap.get(refId);
                    if (matchingEvent != null || !CollectionUtil.isNotEmpty(events) || !(events.get(0) instanceof StartEvent) || currentContainer.getFlowElement(refId) == null) continue;
                    matchingEvent = events.get(0);
                }
                if (matchingEvent != null) continue;
                if (eventMap.containsKey(parentExecution.getActivityId())) {
                    matchingEvent = eventMap.get(parentExecution.getActivityId()).get(0);
                    if (parentExecution.getParentId() == null || !parentExecution.getParent().isMultiInstanceRoot()) continue;
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)parentExecution.getParentId())) {
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                parentExecution = null;
            }
        }
        if (matchingEvent != null && parentExecution != null) {
            ErrorPropagation.executeEventHandler(matchingEvent, parentExecution, currentExecution, error);
            return true;
        }
        return false;
    }

    private static boolean isCallActivity(DelegateExecution delegateExecution) {
        return !delegateExecution.getProcessInstanceId().equals(delegateExecution.getRootProcessInstanceId());
    }

    protected static boolean findCatchingEventsAndExecuteCatchForCallActivity(String errorRef, DelegateExecution execution) {
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity processInstanceExecution = (ExecutionEntity)executionEntityManager.findById(execution.getProcessInstanceId());
        if (processInstanceExecution == null) {
            return false;
        }
        String errorCode = ErrorPropagation.getErrorCodeFromExecution(execution, errorRef);
        Error error = new Error(errorRef, errorCode);
        ExecutionEntity parentExecution = processInstanceExecution.getSuperExecution();
        HashSet<String> toDeleteProcessInstanceIds = new HashSet<String>();
        toDeleteProcessInstanceIds.add(execution.getProcessInstanceId());
        while (!parentExecution.isRootExecution()) {
            Map<String, List<Event>> eventMap = ErrorPropagation.findCatchingEventsForProcess(parentExecution.getProcessDefinitionId(), error);
            if (!eventMap.isEmpty()) {
                for (String processInstanceId : toDeleteProcessInstanceIds) {
                    ErrorPropagation.deleteProcessInstanceEntity(errorRef, execution, executionEntityManager, processInstanceId);
                }
                return ErrorPropagation.executeCatch(eventMap, parentExecution, error);
            }
            toDeleteProcessInstanceIds.add(parentExecution.getProcessInstanceId());
            ExecutionEntity superExecution = parentExecution.getSuperExecution();
            parentExecution = superExecution != null ? superExecution : parentExecution.getProcessInstance();
        }
        return false;
    }

    private static String getErrorCodeFromExecution(DelegateExecution execution, String errorRef) {
        if (execution == null || errorRef == null) {
            return null;
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId());
        return bpmnModel != null ? bpmnModel.getErrorCode(errorRef) : null;
    }

    private static void deleteProcessInstanceEntity(String errorRef, DelegateExecution execution, ExecutionEntityManager executionEntityManager, String processInstanceId) {
        ExecutionEntity processInstanceEntity = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
        executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceEntity.getId(), execution.getCurrentFlowElement() != null ? execution.getCurrentFlowElement().getId() : null, "ERROR_EVENT " + errorRef, false, false);
        ErrorPropagation.dispatchProcessErroredEvent(processInstanceEntity);
    }

    private static void dispatchProcessErroredEvent(ExecutionEntity processInstanceEntity) {
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED_WITH_ERROR_END_EVENT, processInstanceEntity));
        }
    }

    protected static void executeEventHandler(Event event, ExecutionEntity parentExecution, ExecutionEntity currentExecution, Error error) {
        BpmnModel bpmnModel;
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && (bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId())) != null) {
            String resolvedErrorCode = error.getErrorCode() != null ? error.getErrorCode() : ErrorPropagation.retrieveErrorCode(bpmnModel, error.getId());
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createErrorEvent(ActivitiEventType.ACTIVITY_ERROR_RECEIVED, event.getId(), error.getId(), resolvedErrorCode, parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId()));
        }
        if (event instanceof StartEvent) {
            ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
            if (!currentExecution.getParentId().equals(parentExecution.getId())) {
                Context.getAgenda().planDestroyScopeOperation(currentExecution);
            } else {
                executionEntityManager.deleteExecutionAndRelatedData(currentExecution, null);
            }
            ExecutionEntity eventSubProcessExecution = executionEntityManager.createChildExecution(parentExecution);
            eventSubProcessExecution.setCurrentFlowElement((FlowElement)event);
            Context.getAgenda().planContinueProcessOperation(eventSubProcessExecution);
        } else {
            ExecutionEntity boundaryExecution = null;
            List<? extends ExecutionEntity> childExecutions = parentExecution.getExecutions();
            for (ExecutionEntity executionEntity : childExecutions) {
                if (!executionEntity.getActivityId().equals(event.getId())) continue;
                boundaryExecution = executionEntity;
            }
            Context.getAgenda().planTriggerExecutionOperation(boundaryExecution);
        }
    }

    protected static Map<String, List<Event>> findCatchingEventsForProcess(String processDefinitionId, Error error) {
        LinkedHashMap<String, List<Event>> eventMap = new LinkedHashMap<String, List<Event>>();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        String compareErrorCode = error.getErrorCode() != null ? error.getErrorCode() : ErrorPropagation.retrieveErrorCode(bpmnModel, error.getId());
        eventMap.putAll(ErrorPropagation.findCatchingEventSubprocesses(process, bpmnModel, compareErrorCode));
        eventMap.putAll(ErrorPropagation.findCatchingBoundaryEvents(process, bpmnModel, compareErrorCode));
        return eventMap;
    }

    private static Map<String, List<Event>> findCatchingEventSubprocesses(Process process, BpmnModel bpmnModel, String compareErrorCode) {
        StartEvent startEvent;
        LinkedHashMap<String, List<Event>> eventMap = new LinkedHashMap<String, List<Event>>();
        List subProcesses = process.findFlowElementsOfType(EventSubProcess.class, true);
        ArrayList eventSubprocessesWithoutErrorCode = new ArrayList();
        for (EventSubProcess eventSubProcess : subProcesses) {
            for (FlowElement flowElement : eventSubProcess.getFlowElements()) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                startEvent.getErrorEventDefinition().ifPresent(errorEventDef -> {
                    String eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorEventDef.getErrorRef());
                    if (ErrorPropagation.isErrorCodeMatching(eventErrorCode, compareErrorCode)) {
                        if (eventErrorCode == null) {
                            eventSubprocessesWithoutErrorCode.add(eventSubProcess);
                        } else {
                            ErrorPropagation.addEventSubprocessToMap(eventMap, eventSubProcess, startEvent);
                        }
                    }
                });
            }
        }
        for (EventSubProcess eventSubProcess : eventSubprocessesWithoutErrorCode) {
            for (FlowElement flowElement : eventSubProcess.getFlowElements()) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                startEvent.getErrorEventDefinition().ifPresent(errorEventDef -> ErrorPropagation.addEventSubprocessToMap(eventMap, eventSubProcess, startEvent));
            }
        }
        return eventMap;
    }

    private static void addEventSubprocessToMap(Map<String, List<Event>> eventMap, EventSubProcess eventSubProcess, StartEvent startEvent) {
        eventMap.computeIfAbsent(eventSubProcess.getId(), k -> new ArrayList()).add(startEvent);
    }

    private static Map<String, List<Event>> findCatchingBoundaryEvents(Process process, BpmnModel bpmnModel, String compareErrorCode) {
        LinkedHashMap<String, List<Event>> eventMap = new LinkedHashMap<String, List<Event>>();
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        ArrayList boundaryEventsWithoutErrorCode = new ArrayList();
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (boundaryEvent.getAttachedToRefId() == null) continue;
            boundaryEvent.getErrorEventDefinition().ifPresent(errorEventDef -> {
                String eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorEventDef.getErrorRef());
                if (ErrorPropagation.isErrorCodeMatching(eventErrorCode, compareErrorCode)) {
                    if (eventErrorCode == null) {
                        boundaryEventsWithoutErrorCode.add(boundaryEvent);
                    } else {
                        ErrorPropagation.addBoundaryEventToMap(eventMap, boundaryEvent);
                    }
                }
            });
        }
        for (BoundaryEvent boundaryEvent : boundaryEventsWithoutErrorCode) {
            ErrorPropagation.addBoundaryEventToMap(eventMap, boundaryEvent);
        }
        return eventMap;
    }

    private static void addBoundaryEventToMap(Map<String, List<Event>> eventMap, BoundaryEvent boundaryEvent) {
        eventMap.computeIfAbsent(boundaryEvent.getAttachedToRefId(), k -> new ArrayList()).add(boundaryEvent);
    }

    private static boolean isErrorCodeMatching(String eventErrorCode, String compareErrorCode) {
        return eventErrorCode == null || compareErrorCode == null || eventErrorCode.equals(compareErrorCode);
    }

    public static boolean mapException(Exception e, ExecutionEntity execution, List<MapExceptionEntry> exceptionMap) {
        CallActivity callActivity;
        String errorCode = ErrorPropagation.findMatchingExceptionMapping(e, exceptionMap);
        if (errorCode != null) {
            ErrorPropagation.propagateError(errorCode, (DelegateExecution)execution);
            return true;
        }
        DelegateExecution callActivityExecution = null;
        ExecutionEntity parentExecution = execution.getParent();
        while (parentExecution != null && callActivityExecution == null) {
            if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                if (parentExecution.getSuperExecution() != null) {
                    callActivityExecution = parentExecution.getSuperExecution();
                    continue;
                }
                parentExecution = null;
                continue;
            }
            parentExecution = parentExecution.getParent();
        }
        if (callActivityExecution != null && CollectionUtil.isNotEmpty((callActivity = (CallActivity)callActivityExecution.getCurrentFlowElement()).getMapExceptions()) && (errorCode = ErrorPropagation.findMatchingExceptionMapping(e, callActivity.getMapExceptions())) != null) {
            ErrorPropagation.propagateError(errorCode, callActivityExecution);
            return true;
        }
        return false;
    }

    protected static String findMatchingExceptionMapping(Exception e, List<MapExceptionEntry> exceptionMap) {
        String defaultExceptionMapping = null;
        for (MapExceptionEntry me : exceptionMap) {
            Class<?> exceptionClassClass;
            String exceptionClass = me.getClassName();
            String errorCode = me.getErrorCode();
            if (StringUtils.isNotEmpty((CharSequence)errorCode) && StringUtils.isEmpty((CharSequence)exceptionClass) && defaultExceptionMapping == null) {
                defaultExceptionMapping = errorCode;
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)errorCode) || StringUtils.isEmpty((CharSequence)exceptionClass)) continue;
            if (e.getClass().getName().equals(exceptionClass)) {
                return errorCode;
            }
            if (!me.isAndChildren() || !(exceptionClassClass = ReflectUtil.loadClass(exceptionClass)).isAssignableFrom(e.getClass())) continue;
            return errorCode;
        }
        return defaultExceptionMapping;
    }

    protected static String retrieveErrorCode(BpmnModel bpmnModel, String errorRef) {
        String errorCode = bpmnModel.getErrorCode(errorRef);
        return errorCode != null ? errorCode : errorRef;
    }
}

