/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class ErrorThrowingEventListener
extends BaseDelegateEventListener {
    protected String errorCode;

    @Override
    public void onEvent(ActivitiEvent event) {
        if (this.isValidEvent(event)) {
            this.onEventInternal(event);
        }
    }

    protected void onEventInternal(ActivitiEvent event) {
        ExecutionEntity execution = null;
        if (event.getExecutionId() != null) {
            execution = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(event.getExecutionId());
        }
        if (execution == null) {
            throw new ActivitiException("No execution context active and event is not related to an execution. No compensation event can be thrown.");
        }
        try {
            ErrorPropagation.propagateError(this.errorCode, (DelegateExecution)execution);
        }
        catch (Exception e) {
            throw new ActivitiException("Error while propagating error-event", e);
        }
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public boolean isFailOnException() {
        return true;
    }
}

