/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Collection;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class RemoveTaskVariablesCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    private final Collection<String> variableNames;
    private final boolean isLocal;

    public RemoveTaskVariablesCmd(String taskId, Collection<String> variableNames, boolean isLocal) {
        super(taskId);
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (this.isLocal) {
            task.removeVariablesLocal(this.variableNames);
        } else {
            task.removeVariables(this.variableNames);
        }
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot remove variables from a suspended task.";
    }
}

