/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.variable.ByteArrayType;
import org.activiti.engine.impl.variable.DeserializedObject;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VerifyDeserializedObjectCommandContextCloseListener;

public class SerializableType
extends ByteArrayType {
    public static final String TYPE_NAME = "serializable";
    protected boolean trackDeserializedObjects;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    public SerializableType() {
    }

    public SerializableType(boolean trackDeserializedObjects) {
        this.trackDeserializedObjects = trackDeserializedObjects;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        Object cachedObject = valueFields.getCachedValue();
        if (cachedObject != null) {
            return cachedObject;
        }
        byte[] bytes = (byte[])super.getValue(valueFields);
        if (bytes != null) {
            Object deserializedObject = this.deserialize(bytes, valueFields);
            valueFields.setCachedValue(deserializedObject);
            if (this.trackDeserializedObjects && valueFields instanceof VariableInstanceEntity) {
                Context.getCommandContext().addCloseListener(new VerifyDeserializedObjectCommandContextCloseListener(new DeserializedObject(this, valueFields.getCachedValue(), bytes, (VariableInstanceEntity)valueFields)));
            }
            return deserializedObject;
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        byte[] bytes = this.serialize(value, valueFields);
        valueFields.setCachedValue(value);
        super.setValue(bytes, valueFields);
        if (this.trackDeserializedObjects && valueFields instanceof VariableInstanceEntity) {
            Context.getCommandContext().addCloseListener(new VerifyDeserializedObjectCommandContextCloseListener(new DeserializedObject(this, valueFields.getCachedValue(), bytes, (VariableInstanceEntity)valueFields)));
        }
    }

    public byte[] serialize(Object value, ValueFields valueFields) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = this.createObjectOutputStream(baos);
            oos.writeObject(value);
        }
        catch (Exception e) {
            throw new ActivitiException("Couldn't serialize value '" + String.valueOf(value) + "' in variable '" + valueFields.getName() + "'", e);
        }
        finally {
            IoUtil.closeSilently(oos);
        }
        return baos.toByteArray();
    }

    public Object deserialize(byte[] bytes, ValueFields valueFields) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            Object deserializedObject;
            ObjectInputStream ois = this.createObjectInputStream(bais);
            Object object = deserializedObject = ois.readObject();
            return object;
        }
        catch (Exception e) {
            throw new ActivitiException("Couldn't deserialize object in variable '" + valueFields.getName() + "'", e);
        }
        finally {
            IoUtil.closeSilently(bais);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        return value instanceof Serializable;
    }

    protected ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStream(this, is){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return ReflectUtil.loadClass(desc.getName());
            }
        };
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream os) throws IOException {
        return new ObjectOutputStream(os);
    }
}

