/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.CountingExecutionEntity;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntityManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.impl.persistence.entity.data.IdentityLinkDataManager;

public class IdentityLinkEntityManagerImpl
extends AbstractEntityManager<IdentityLinkEntity>
implements IdentityLinkEntityManager {
    protected IdentityLinkDataManager identityLinkDataManager;

    public IdentityLinkEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, IdentityLinkDataManager identityLinkDataManager) {
        super(processEngineConfiguration);
        this.identityLinkDataManager = identityLinkDataManager;
    }

    @Override
    protected DataManager<IdentityLinkEntity> getDataManager() {
        return this.identityLinkDataManager;
    }

    @Override
    public void insert(IdentityLinkEntity entity, boolean fireCreateEvent) {
        CountingExecutionEntity executionEntity;
        super.insert(entity, fireCreateEvent);
        this.getHistoryManager().recordIdentityLinkCreated(entity);
        if (entity.getProcessInstanceId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(entity.getProcessInstanceId()))) {
            executionEntity.setIdentityLinkCount(executionEntity.getIdentityLinkCount() + 1);
        }
    }

    @Override
    public void deleteIdentityLink(IdentityLinkEntity identityLink, boolean cascadeHistory) {
        CountingExecutionEntity executionEntity;
        this.delete(identityLink, false);
        if (cascadeHistory) {
            this.getHistoryManager().deleteHistoricIdentityLink(identityLink.getId());
        }
        if (identityLink.getProcessInstanceId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(identityLink.getProcessInstanceId()))) {
            executionEntity.setIdentityLinkCount(executionEntity.getIdentityLinkCount() - 1);
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, identityLink));
        }
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByTaskId(String taskId) {
        return this.identityLinkDataManager.findIdentityLinksByTaskId(taskId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessInstanceId(String processInstanceId) {
        return this.identityLinkDataManager.findIdentityLinksByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessDefinitionId(String processDefinitionId) {
        return this.identityLinkDataManager.findIdentityLinksByProcessDefinitionId(processDefinitionId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByTaskUserGroupAndType(String taskId, String userId, String groupId, String type) {
        return this.identityLinkDataManager.findIdentityLinkByTaskUserGroupAndType(taskId, userId, groupId, type);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessInstanceUserGroupAndType(String processInstanceId, String userId, String groupId, String type) {
        return this.identityLinkDataManager.findIdentityLinkByProcessInstanceUserGroupAndType(processInstanceId, userId, groupId, type);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessDefinitionUserAndGroup(String processDefinitionId, String userId, String groupId) {
        return this.identityLinkDataManager.findIdentityLinkByProcessDefinitionUserAndGroup(processDefinitionId, userId, groupId);
    }

    @Override
    public IdentityLinkEntity addIdentityLink(ExecutionEntity executionEntity, String userId, String groupId, String type) {
        return this.addIdentityLink(executionEntity, userId, groupId, type, null);
    }

    @Override
    public IdentityLinkEntity addIdentityLink(ExecutionEntity executionEntity, String userId, String groupId, String type, byte[] details) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)this.identityLinkDataManager.create();
        executionEntity.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setProcessInstance(executionEntity.getProcessInstance() != null ? executionEntity.getProcessInstance() : executionEntity);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        identityLinkEntity.setDetails(details);
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addIdentityLink(TaskEntity taskEntity, String userId, String groupId, String type) {
        return this.addIdentityLink(taskEntity, userId, groupId, type, null);
    }

    @Override
    public IdentityLinkEntity addIdentityLink(TaskEntity taskEntity, String userId, String groupId, String type, byte[] details) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)this.identityLinkDataManager.create();
        taskEntity.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setTask(taskEntity);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        identityLinkEntity.setDetails(details);
        this.insert(identityLinkEntity);
        if (userId != null && taskEntity.getProcessInstanceId() != null) {
            this.involveUser(taskEntity.getProcessInstance(), userId, "participant");
        }
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addIdentityLink(ProcessDefinitionEntity processDefinitionEntity, String userId, String groupId) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)this.identityLinkDataManager.create();
        processDefinitionEntity.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setProcessDef(processDefinitionEntity);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType("candidate");
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity involveUser(ExecutionEntity executionEntity, String userId, String type) {
        for (IdentityLinkEntity identityLink : executionEntity.getIdentityLinks()) {
            if (!identityLink.isUser() || !identityLink.getUserId().equals(userId)) continue;
            return identityLink;
        }
        return this.addIdentityLink(executionEntity, userId, null, type);
    }

    @Override
    public void addCandidateUser(TaskEntity taskEntity, String userId) {
        this.addIdentityLink(taskEntity, userId, null, "candidate");
    }

    @Override
    public void addCandidateUsers(TaskEntity taskEntity, Collection<String> candidateUsers) {
        for (String candidateUser : candidateUsers) {
            this.addCandidateUser(taskEntity, candidateUser);
        }
    }

    @Override
    public void addCandidateGroup(TaskEntity taskEntity, String groupId) {
        this.addIdentityLink(taskEntity, null, groupId, "candidate");
    }

    @Override
    public void addCandidateGroups(TaskEntity taskEntity, Collection<String> candidateGroups) {
        for (String candidateGroup : candidateGroups) {
            this.addCandidateGroup(taskEntity, candidateGroup);
        }
    }

    @Override
    public void addGroupIdentityLink(TaskEntity taskEntity, String groupId, String identityLinkType) {
        this.addIdentityLink(taskEntity, null, groupId, identityLinkType);
    }

    @Override
    public void addUserIdentityLink(TaskEntity taskEntity, String userId, String identityLinkType) {
        this.addIdentityLink(taskEntity, userId, null, identityLinkType);
    }

    @Override
    public void addUserIdentityLink(TaskEntity taskEntity, String userId, String identityLinkType, byte[] details) {
        this.addIdentityLink(taskEntity, userId, null, identityLinkType, details);
    }

    @Override
    public void deleteIdentityLink(ExecutionEntity executionEntity, String userId, String groupId, String type) {
        String id = executionEntity.getProcessInstanceId() != null ? executionEntity.getProcessInstanceId() : executionEntity.getId();
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByProcessInstanceUserGroupAndType(id, userId, groupId, type);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, true);
        }
        executionEntity.getIdentityLinks().removeAll(identityLinks);
    }

    @Override
    public void deleteIdentityLink(TaskEntity taskEntity, String userId, String groupId, String type) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByTaskUserGroupAndType(taskEntity.getId(), userId, groupId, type);
        ArrayList<String> identityLinkIds = new ArrayList<String>();
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, true);
            identityLinkIds.add(identityLink.getId());
        }
        ArrayList<IdentityLinkEntity> removedIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
        for (IdentityLinkEntity identityLinkEntity : taskEntity.getIdentityLinks()) {
            if (!"candidate".equals(identityLinkEntity.getType()) || identityLinkIds.contains(identityLinkEntity.getId()) || (userId == null || !userId.equals(identityLinkEntity.getUserId())) && (groupId == null || !groupId.equals(identityLinkEntity.getGroupId()))) continue;
            this.deleteIdentityLink(identityLinkEntity, true);
            removedIdentityLinkEntities.add(identityLinkEntity);
        }
        taskEntity.getIdentityLinks().removeAll(removedIdentityLinkEntities);
    }

    @Override
    public void deleteIdentityLink(ProcessDefinitionEntity processDefinitionEntity, String userId, String groupId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByProcessDefinitionUserAndGroup(processDefinitionEntity.getId(), userId, groupId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, false);
        }
    }

    @Override
    public void deleteIdentityLinksByTaskId(String taskId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinksByTaskId(taskId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, false);
        }
    }

    @Override
    public void deleteIdentityLinksByProcDef(String processDefId) {
        this.identityLinkDataManager.deleteIdentityLinksByProcDef(processDefId);
    }

    public IdentityLinkDataManager getIdentityLinkDataManager() {
        return this.identityLinkDataManager;
    }

    public void setIdentityLinkDataManager(IdentityLinkDataManager identityLinkDataManager) {
        this.identityLinkDataManager = identityLinkDataManager;
    }
}

