/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.AdhocSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class GetEnabledActivitiesForAdhocSubProcessCmd
implements Command<List<FlowNode>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;

    public GetEnabledActivitiesForAdhocSubProcessCmd(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public List<FlowNode> execute(CommandContext commandContext) {
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("No execution found for id '" + this.executionId + "'", ExecutionEntity.class);
        }
        if (!(execution.getCurrentFlowElement() instanceof AdhocSubProcess)) {
            throw new ActivitiException("The current flow element of the requested execution is not an ad-hoc sub process");
        }
        ArrayList<FlowNode> enabledFlowNodes = new ArrayList<FlowNode>();
        AdhocSubProcess adhocSubProcess = (AdhocSubProcess)execution.getCurrentFlowElement();
        if (adhocSubProcess.hasSequentialOrdering() && execution.getExecutions().size() > 0) {
            return enabledFlowNodes;
        }
        for (FlowElement flowElement : adhocSubProcess.getFlowElements()) {
            FlowNode flowNode;
            if (!(flowElement instanceof FlowNode) || (flowNode = (FlowNode)flowElement).getIncomingFlows().size() != 0) continue;
            enabledFlowNodes.add(flowNode);
        }
        return enabledFlowNodes;
    }
}

