/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.variable.AuthenticatedUserELResolver;
import org.activiti.engine.impl.el.variable.ExecutionElResolver;
import org.activiti.engine.impl.el.variable.ProcessInitiatorELResolver;
import org.activiti.engine.impl.el.variable.TaskElResolver;
import org.activiti.engine.impl.el.variable.VariableElResolver;
import org.activiti.engine.impl.el.variable.VariableScopeItemELResolver;

public class VariableScopeElResolver
extends ELResolver {
    protected VariableScope variableScope;
    private List<VariableScopeItemELResolver> variableScopeItemELResolvers;

    public VariableScopeElResolver(VariableScope variableScope) {
        this.variableScope = variableScope;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            String variable = (String)property;
            for (VariableScopeItemELResolver variableScopeItemELResolver : this.getVariableScopeItemELResolvers()) {
                if (!variableScopeItemELResolver.canResolve(variable, this.variableScope)) continue;
                context.setPropertyResolved(true);
                return variableScopeItemELResolver.resolve(variable, this.variableScope);
            }
        }
        return null;
    }

    protected List<VariableScopeItemELResolver> getVariableScopeItemELResolvers() {
        if (this.variableScopeItemELResolvers == null) {
            this.variableScopeItemELResolvers = Arrays.asList(new ExecutionElResolver(), new TaskElResolver(), new AuthenticatedUserELResolver(), new ProcessInitiatorELResolver(), new VariableElResolver(Context.getProcessEngineConfiguration().getObjectMapper()));
        }
        return this.variableScopeItemELResolvers;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null) {
            String variable = (String)property;
            return !this.variableScope.hasVariable(variable);
        }
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        String variable;
        if (base == null && this.variableScope.hasVariable(variable = (String)property)) {
            this.variableScope.setVariable(variable, value);
        }
    }

    public Class<?> getCommonPropertyType(ELContext arg0, Object arg1) {
        return Object.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        return null;
    }

    public Class<?> getType(ELContext arg0, Object arg1, Object arg2) {
        return Object.class;
    }
}

