/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.test.mock;

import java.util.Collections;
import java.util.List;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.bpmn.parser.factory.ActivityBehaviorFactory;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.test.NoOpServiceTask;
import org.activiti.engine.test.TestActivityBehaviorFactory;

public class ActivitiMockSupport {
    protected TestActivityBehaviorFactory testActivityBehaviorFactory;

    public ActivitiMockSupport(TestActivityBehaviorFactory testActivityBehaviorFactory) {
        this.testActivityBehaviorFactory = testActivityBehaviorFactory;
    }

    public ActivitiMockSupport(ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        ActivityBehaviorFactory existingActivityBehaviorFactory = processEngineConfiguration.getActivityBehaviorFactory();
        this.testActivityBehaviorFactory = new TestActivityBehaviorFactory(existingActivityBehaviorFactory);
        processEngineConfiguration.setActivityBehaviorFactory(this.testActivityBehaviorFactory);
        processEngineConfiguration.getBpmnParser().setActivityBehaviorFactory(this.testActivityBehaviorFactory);
    }

    public static boolean isMockSupportPossible(ProcessEngine processEngine) {
        return processEngine instanceof ProcessEngineImpl;
    }

    public void mockServiceTaskWithClassDelegate(String originalClassFqn, Class<?> mockedClass) {
        this.testActivityBehaviorFactory.addClassDelegateMock(originalClassFqn, mockedClass);
    }

    public void mockServiceTaskWithClassDelegate(String originalClassFqn, String mockedClassFqn) {
        this.testActivityBehaviorFactory.addClassDelegateMock(originalClassFqn, mockedClassFqn);
    }

    public void setAllServiceTasksNoOp() {
        this.testActivityBehaviorFactory.setAllServiceTasksNoOp();
    }

    public void addNoOpServiceTaskById(String id) {
        this.testActivityBehaviorFactory.addNoOpServiceTaskById(id);
    }

    public void addNoOpServiceTaskByClassName(String className) {
        this.testActivityBehaviorFactory.addNoOpServiceTaskByClassName(className);
    }

    public int getNrOfNoOpServiceTaskExecutions() {
        return NoOpServiceTask.CALL_COUNT.get();
    }

    public List<String> getExecutedNoOpServiceTaskDelegateClassNames() {
        return Collections.unmodifiableList(NoOpServiceTask.NAMES);
    }

    public void reset() {
        this.testActivityBehaviorFactory.reset();
    }
}

