/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper.task;

import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import org.activiti.engine.impl.bpmn.helper.task.TaskComparator;
import org.activiti.engine.impl.persistence.entity.TaskEntityImpl;
import org.activiti.engine.task.TaskInfo;
import org.apache.commons.lang3.StringUtils;

public class TaskComparatorImpl
implements TaskComparator {
    private TaskInfo originalTask;
    private TaskInfo updatedTask;

    public void setOriginalTask(TaskInfo task) {
        this.originalTask = this.copyInformationFromTaskInfo(task);
    }

    public void setUpdatedTask(TaskInfo task) {
        if (this.originalTask == null) {
            throw new IllegalArgumentException("an originalTask is needed before setting an updatedTask");
        }
        this.updatedTask = this.copyInformationFromTaskInfo(task);
    }

    @Override
    public TaskInfo getOriginalTask() {
        return this.originalTask;
    }

    @Override
    public TaskInfo getUpdatedTask() {
        return this.updatedTask;
    }

    @Override
    public boolean hasTaskNameChanged() {
        return this.hasStringFieldChanged(TaskInfo::getName);
    }

    @Override
    public boolean hasTaskDefinitionKeyChanged() {
        return this.hasStringFieldChanged(TaskInfo::getTaskDefinitionKey);
    }

    @Override
    public boolean hasTaskAssigneeChanged() {
        return this.hasStringFieldChanged(TaskInfo::getAssignee);
    }

    @Override
    public boolean hasTaskDueDateChanged() {
        return this.hasDateFieldChanged(TaskInfo::getDueDate);
    }

    @Override
    public boolean hasTaskDescriptionChanged() {
        return this.hasStringFieldChanged(TaskInfo::getDescription);
    }

    @Override
    public boolean hasTaskOwnerChanged() {
        return this.hasStringFieldChanged(TaskInfo::getOwner);
    }

    @Override
    public boolean hasTaskPriorityChanged() {
        return this.hasIntegerFieldChanged(TaskInfo::getPriority);
    }

    @Override
    public boolean hasTaskCategoryChanged() {
        return this.hasStringFieldChanged(TaskInfo::getCategory);
    }

    @Override
    public boolean hasTaskFormKeyChanged() {
        return this.hasStringFieldChanged(TaskInfo::getFormKey);
    }

    @Override
    public boolean hasTaskParentIdChanged() {
        return this.hasStringFieldChanged(TaskInfo::getParentTaskId);
    }

    private boolean hasStringFieldChanged(Function<TaskInfo, String> comparableTaskGetter) {
        if (this.originalTask != null && this.updatedTask != null) {
            return !StringUtils.equals((CharSequence)comparableTaskGetter.apply(this.originalTask), (CharSequence)comparableTaskGetter.apply(this.updatedTask));
        }
        return false;
    }

    private boolean hasIntegerFieldChanged(Function<TaskInfo, Integer> comparableTaskGetter) {
        if (this.originalTask != null && this.updatedTask != null) {
            return !Objects.equals(comparableTaskGetter.apply(this.originalTask), comparableTaskGetter.apply(this.updatedTask));
        }
        return false;
    }

    private boolean hasDateFieldChanged(Function<TaskInfo, Date> comparableTaskGetter) {
        if (this.originalTask != null && this.updatedTask != null) {
            Date originalDate = comparableTaskGetter.apply(this.originalTask);
            Date newDate = comparableTaskGetter.apply(this.updatedTask);
            return originalDate == null && newDate != null || originalDate != null && newDate == null || originalDate != null && !originalDate.equals(newDate);
        }
        return false;
    }

    private TaskInfo copyInformationFromTaskInfo(TaskInfo task) {
        if (task != null) {
            TaskEntityImpl duplicatedTask = new TaskEntityImpl();
            duplicatedTask.setName(task.getName());
            duplicatedTask.setDueDate(task.getDueDate());
            duplicatedTask.setDescription(task.getDescription());
            duplicatedTask.setId(task.getId());
            duplicatedTask.setOwner(task.getOwner());
            duplicatedTask.setPriority(task.getPriority());
            duplicatedTask.setCategory(task.getCategory());
            duplicatedTask.setFormKey(task.getFormKey());
            duplicatedTask.setAssignee(task.getAssignee());
            duplicatedTask.setTaskDefinitionKey(task.getTaskDefinitionKey());
            duplicatedTask.setParentTaskId(task.getParentTaskId());
            return duplicatedTask;
        }
        throw new IllegalArgumentException("task must be non-null");
    }
}

