/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Objects;
import org.activiti.engine.delegate.DelegateExecution;

public class MappingExecutionContext {
    private String processDefinitionId;
    private String activityId;
    private DelegateExecution execution;

    public MappingExecutionContext(DelegateExecution delegateExecution) {
        this.processDefinitionId = delegateExecution.getProcessDefinitionId();
        this.activityId = delegateExecution.getCurrentActivityId();
        this.execution = delegateExecution;
    }

    public MappingExecutionContext(String processDefinitionId, String activityId) {
        this.processDefinitionId = processDefinitionId;
        this.activityId = activityId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public boolean hasExecution() {
        return this.execution != null;
    }

    public DelegateExecution getExecution() {
        return this.execution;
    }

    public static MappingExecutionContext buildMappingExecutionContext(DelegateExecution delegateExecution) {
        return new MappingExecutionContext(delegateExecution);
    }

    public static MappingExecutionContext buildMappingExecutionContext(String processDefinitionId, String activityId) {
        return new MappingExecutionContext(processDefinitionId, activityId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingExecutionContext that = (MappingExecutionContext)o;
        return Objects.equals(this.processDefinitionId, that.processDefinitionId) && Objects.equals(this.activityId, that.activityId);
    }

    public int hashCode() {
        return Objects.hash(this.processDefinitionId, this.activityId);
    }
}

