/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.el;

import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.core.el.CommonELResolversUtil;
import org.activiti.core.el.CustomFunctionProvider;
import org.activiti.core.el.ELContextBuilder;
import org.activiti.core.el.ExpressionResolver;

public class JuelExpressionResolver
implements ExpressionResolver {
    private final ExpressionFactory expressionFactory;
    private final List<CustomFunctionProvider> customFunctionProviders;

    public JuelExpressionResolver() {
        this(ExpressionFactory.newInstance());
    }

    public JuelExpressionResolver(ExpressionFactory expressionFactory) {
        this(expressionFactory, new ArrayList<CustomFunctionProvider>());
    }

    public JuelExpressionResolver(ExpressionFactory expressionFactory, List<CustomFunctionProvider> customFunctionProviders) {
        this.expressionFactory = expressionFactory;
        this.customFunctionProviders = customFunctionProviders;
    }

    @Override
    public <T> T resolveExpression(String expression, Map<String, Object> variables, Class<T> type) {
        if (expression == null) {
            return null;
        }
        ELContext context = this.buildContext(variables);
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(context, expression, type);
        return (T)valueExpression.getValue(context);
    }

    protected ELContext buildContext(Map<String, Object> variables) {
        return new ELContextBuilder().withResolvers(CommonELResolversUtil.arrayResolver(), CommonELResolversUtil.listResolver(), CommonELResolversUtil.mapResolver(), CommonELResolversUtil.jsonNodeResolver(), CommonELResolversUtil.beanResolver()).withVariables(variables).buildWithCustomFunctions(this.customFunctionProviders);
    }
}

