/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ScriptTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;

public class ScriptTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ScriptTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        ScriptTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ScriptTask", ScriptTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ScriptTask.class, ScriptTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "ScriptTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        ScriptTask scriptTask = (ScriptTask)baseElement;
        propertiesNode.put("scriptformat", scriptTask.getScriptFormat());
        propertiesNode.put("scripttext", scriptTask.getScript());
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        ScriptTask task = new ScriptTask();
        task.setScriptFormat(this.getPropertyValueAsString("scriptformat", elementNode));
        task.setScript(this.getPropertyValueAsString("scripttext", elementNode));
        return task;
    }
}

