/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.el.juel.misc;

import jakarta.el.ELException;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.activiti.core.el.juel.misc.LocalMessages;
import org.activiti.core.el.juel.misc.TypeConverter;

public class TypeConverterImpl
implements TypeConverter {
    private static final long serialVersionUID = 1L;

    protected Boolean coerceToBoolean(Object value) {
        if (value == null || "".equals(value)) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), Boolean.class));
    }

    protected Character coerceToCharacter(Object value) {
        if (value == null || "".equals(value)) {
            return Character.valueOf('\u0000');
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof Number) {
            return Character.valueOf((char)((Number)value).shortValue());
        }
        if (value instanceof String) {
            return Character.valueOf(((String)value).charAt(0));
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), Character.class));
    }

    protected BigDecimal coerceToBigDecimal(Object value) {
        if (value == null || "".equals(value)) {
            return BigDecimal.valueOf(0L);
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get("error.coerce.value", value, value.getClass(), BigDecimal.class));
            }
        }
        if (value instanceof Character) {
            return new BigDecimal((short)((Character)value).charValue());
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), BigDecimal.class));
    }

    protected BigInteger coerceToBigInteger(Object value) {
        if (value == null || "".equals(value)) {
            return BigInteger.valueOf(0L);
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            try {
                return new BigInteger((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get("error.coerce.value", value, value.getClass(), BigInteger.class));
            }
        }
        if (value instanceof Character) {
            return BigInteger.valueOf((short)((Character)value).charValue());
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), BigInteger.class));
    }

    protected Double coerceToDouble(Object value) {
        if (value == null || "".equals(value)) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get("error.coerce.value", value, value.getClass(), Double.class));
            }
        }
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), Double.class));
    }

    protected Float coerceToFloat(Object value) {
        if (value == null || "".equals(value)) {
            return Float.valueOf(0.0f);
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            try {
                return Float.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get("error.coerce.value", value, value.getClass(), Float.class));
            }
        }
        if (value instanceof Character) {
            return Float.valueOf((short)((Character)value).charValue());
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), Float.class));
    }

    protected Long coerceToLong(Object value) {
        if (value == null || "".equals(value)) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get("error.coerce.value", value, value.getClass(), Long.class));
            }
        }
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), Long.class));
    }

    protected Integer coerceToInteger(Object value) {
        if (value == null || "".equals(value)) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get("error.coerce.value", value, value.getClass(), Integer.class));
            }
        }
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), Integer.class));
    }

    protected Short coerceToShort(Object value) {
        if (value == null || "".equals(value)) {
            return (short)0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            try {
                return Short.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get("error.coerce.value", value, value.getClass(), Short.class));
            }
        }
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), Short.class));
    }

    protected Byte coerceToByte(Object value) {
        if (value == null || "".equals(value)) {
            return (byte)0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            try {
                return Byte.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get("error.coerce.value", value, value.getClass(), Byte.class));
            }
        }
        if (value instanceof Character) {
            return Short.valueOf((short)((Character)value).charValue()).byteValue();
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), Byte.class));
    }

    protected String coerceToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value.toString();
    }

    protected <T extends Enum<T>> T coerceToEnum(Object value, Class<T> type) {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)((Enum)value);
        }
        if (value instanceof String) {
            try {
                return Enum.valueOf(type, (String)value);
            }
            catch (IllegalArgumentException e) {
                throw new ELException(LocalMessages.get("error.coerce.value", value, value.getClass(), type));
            }
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), type));
    }

    protected Object coerceStringToType(String value, Class<?> type) {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor == null) {
            if ("".equals(value)) {
                return null;
            }
            throw new ELException(LocalMessages.get("error.coerce.type", value, String.class, type));
        }
        if ("".equals(value)) {
            try {
                editor.setAsText(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        try {
            editor.setAsText(value);
        }
        catch (IllegalArgumentException e) {
            throw new ELException(LocalMessages.get("error.coerce.value", value, value.getClass(), type));
        }
        return editor.getValue();
    }

    protected Object coerceToType(Object value, Class<?> type) {
        if (type == String.class) {
            return this.coerceToString(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return this.coerceToLong(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return this.coerceToDouble(value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return this.coerceToBoolean(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return this.coerceToInteger(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return this.coerceToFloat(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return this.coerceToShort(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return this.coerceToByte(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return this.coerceToCharacter(value);
        }
        if (type == BigDecimal.class) {
            return this.coerceToBigDecimal(value);
        }
        if (type == BigInteger.class) {
            return this.coerceToBigInteger(value);
        }
        if (type.getSuperclass() == Enum.class) {
            return this.coerceToEnum(value, type);
        }
        if (value == null || value.getClass() == type || type.isInstance(value)) {
            return value;
        }
        if (value instanceof String) {
            return this.coerceStringToType((String)value, type);
        }
        throw new ELException(LocalMessages.get("error.coerce.type", value, value.getClass(), type));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public <T> T convert(Object value, Class<T> type) throws ELException {
        return (T)this.coerceToType(value, type);
    }
}

