/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.el.juel.tree.impl.ast;

import jakarta.el.ELContext;
import java.util.List;
import org.activiti.core.el.juel.tree.Bindings;
import org.activiti.core.el.juel.tree.impl.ast.AstNode;
import org.activiti.core.el.juel.tree.impl.ast.AstRightValue;

public class AstParameters
extends AstRightValue {
    private final List<AstNode> nodes;

    public AstParameters(List<AstNode> nodes) {
        this.nodes = nodes;
    }

    public Object[] eval(Bindings bindings, ELContext context) {
        Object[] result = new Object[this.nodes.size()];
        for (int i = 0; i < this.nodes.size(); ++i) {
            result[i] = this.nodes.get(i).eval(bindings, context);
        }
        return result;
    }

    public String toString() {
        return "(...)";
    }

    @Override
    public void appendStructure(StringBuilder builder, Bindings bindings) {
        builder.append("(");
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.nodes.get(i).appendStructure(builder, bindings);
        }
        builder.append(")");
    }

    @Override
    public int getCardinality() {
        return this.nodes.size();
    }

    @Override
    public AstNode getChild(int i) {
        return this.nodes.get(i);
    }
}

