/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.el.juel.tree.impl.ast;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueReference;
import org.activiti.core.el.juel.misc.LocalMessages;
import org.activiti.core.el.juel.tree.Bindings;
import org.activiti.core.el.juel.tree.Node;
import org.activiti.core.el.juel.tree.impl.ast.AstNode;
import org.activiti.core.el.juel.tree.impl.ast.AstParameters;
import org.activiti.core.el.juel.tree.impl.ast.AstProperty;

public class AstMethod
extends AstNode {
    private final AstProperty property;
    private final AstParameters params;

    public AstMethod(AstProperty property, AstParameters params) {
        this.property = property;
        this.params = params;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public Class<?> getType(Bindings bindings, ELContext context) {
        return null;
    }

    @Override
    public boolean isReadOnly(Bindings bindings, ELContext context) {
        return true;
    }

    @Override
    public void setValue(Bindings bindings, ELContext context, Object value) {
        throw new ELException(LocalMessages.get("error.value.set.rvalue", this.getStructuralId(bindings)));
    }

    @Override
    public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        return null;
    }

    @Override
    public boolean isLeftValue() {
        return false;
    }

    @Override
    public boolean isMethodInvocation() {
        return true;
    }

    @Override
    public final ValueReference getValueReference(Bindings bindings, ELContext context) {
        return null;
    }

    @Override
    public void appendStructure(StringBuilder builder, Bindings bindings) {
        this.property.appendStructure(builder, bindings);
        this.params.appendStructure(builder, bindings);
    }

    protected Object eval(Bindings bindings, ELContext context, boolean answerNullIfBaseIsNull) {
        Object base = this.property.getPrefix().eval(bindings, context);
        if (base == null) {
            if (answerNullIfBaseIsNull) {
                return null;
            }
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.property.getPrefix()));
        }
        Object method = this.property.getProperty(bindings, context);
        if (method == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.method.notfound", "null", base));
        }
        String name = bindings.convert(method, String.class);
        context.setPropertyResolved(false);
        Object result = context.getELResolver().invoke(context, base, (Object)name, null, this.params.eval(bindings, context));
        if (!context.isPropertyResolved()) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", name, base.getClass()));
        }
        return result;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        return this.eval(bindings, context, true);
    }

    @Override
    public Object invoke(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes, Object[] paramValues) {
        return this.eval(bindings, context, false);
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public Node getChild(int i) {
        return i == 0 ? this.property : (i == 1 ? this.params : null);
    }

    public String toString() {
        return "<method>";
    }
}

