/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ValidatorImpl;

public class DiagramInterchangeInfoValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        HashMap<String, String> params;
        if (!bpmnModel.getLocationMap().isEmpty()) {
            for (String bpmnReference : bpmnModel.getLocationMap().keySet()) {
                if (bpmnModel.getFlowElement(bpmnReference) == null) {
                    if (bpmnModel.getArtifact(bpmnReference) != null || bpmnModel.getPool(bpmnReference) != null || bpmnModel.getLane(bpmnReference) != null) continue;
                    params = new HashMap();
                    params.put("bpmnReference", bpmnReference);
                    this.addWarning(errors, "DI_INVALID_REFERENCE", null, (BaseElement)bpmnModel.getFlowElement(bpmnReference), params);
                    continue;
                }
                if (bpmnModel.getFlowElement(bpmnReference) instanceof FlowNode) continue;
                params = new HashMap<String, String>();
                params.put("bpmnReference", bpmnReference);
                this.addWarning(errors, "DI_DOES_NOT_REFERENCE_FLOWNODE", null, (BaseElement)bpmnModel.getFlowElement(bpmnReference), params);
            }
        }
        if (!bpmnModel.getFlowLocationMap().isEmpty()) {
            for (String bpmnReference : bpmnModel.getFlowLocationMap().keySet()) {
                if (bpmnModel.getFlowElement(bpmnReference) == null && bpmnModel.getMessageFlow(bpmnReference) == null && bpmnModel.getArtifact(bpmnReference) == null) {
                    params = new HashMap();
                    params.put("bpmnReference", bpmnReference);
                    this.addWarning(errors, "DI_INVALID_REFERENCE", null, (BaseElement)bpmnModel.getFlowElement(bpmnReference), params);
                }
                if (bpmnModel.getFlowElement(bpmnReference) == null || bpmnModel.getFlowElement(bpmnReference) instanceof SequenceFlow) continue;
                params = new HashMap();
                params.put("bpmnReference", bpmnReference);
                this.addWarning(errors, "DI_DOES_NOT_REFERENCE_SEQ_FLOW", null, (BaseElement)bpmnModel.getFlowElement(bpmnReference), params);
            }
        }
    }
}

