/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.Validator;

public abstract class ValidatorImpl
implements Validator {
    public void addError(List<ValidationError> validationErrors, ValidationError error) {
        validationErrors.add(error);
    }

    protected void addError(List<ValidationError> validationErrors, String problem) {
        this.addError(validationErrors, problem, null, null, false);
    }

    protected void addError(List<ValidationError> validationErrors, String problem, Map<String, String> params) {
        this.addError(validationErrors, problem, null, null, false, params);
    }

    protected void addError(List<ValidationError> validationErrors, String problem, BaseElement baseElement) {
        this.addError(validationErrors, problem, null, baseElement);
    }

    protected void addError(List<ValidationError> validationErrors, String problem, BaseElement baseElement, Map<String, String> params) {
        this.addError(validationErrors, problem, null, baseElement, params);
    }

    protected void addError(List<ValidationError> validationErrors, String problem, Process process, BaseElement baseElement) {
        this.addError(validationErrors, problem, process, baseElement, false);
    }

    protected void addError(List<ValidationError> validationErrors, String problem, Process process, BaseElement baseElement, Map<String, String> params) {
        this.addError(validationErrors, problem, process, baseElement, false, params);
    }

    protected void addWarning(List<ValidationError> validationErrors, String problem, Process process, BaseElement baseElement) {
        this.addError(validationErrors, problem, process, baseElement, true);
    }

    protected void addWarning(List<ValidationError> validationErrors, String problem, Process process, BaseElement baseElement, Map<String, String> params) {
        this.addError(validationErrors, problem, process, baseElement, true, params);
    }

    protected void addError(List<ValidationError> validationErrors, String problem, Process process, BaseElement baseElement, boolean isWarning) {
        this.addError(validationErrors, problem, process, baseElement, isWarning, new HashMap<String, String>());
    }

    protected void addError(List<ValidationError> validationErrors, String problem, Process process, BaseElement baseElement, boolean isWarning, Map<String, String> params) {
        ValidationError error = new ValidationError();
        error.setWarning(isWarning);
        if (process != null) {
            error.setProcessDefinitionId(process.getId());
            error.setProcessDefinitionName(process.getName());
        }
        if (baseElement != null) {
            error.setXmlLineNumber(baseElement.getXmlRowNumber());
            error.setXmlColumnNumber(baseElement.getXmlColumnNumber());
        }
        error.setKey(problem);
        error.setProblem(problem);
        error.setDefaultDescription(problem);
        error.setParams(params);
        if (baseElement instanceof FlowElement) {
            FlowElement flowElement = (FlowElement)baseElement;
            error.setActivityId(flowElement.getId());
            error.setActivityName(flowElement.getName());
        }
        this.addError(validationErrors, error);
    }

    protected void addError(List<ValidationError> validationErrors, String problem, Process process, String id) {
        ValidationError error = new ValidationError();
        if (process != null) {
            error.setProcessDefinitionId(process.getId());
            error.setProcessDefinitionName(process.getName());
        }
        error.setKey(problem);
        error.setProblem(problem);
        error.setDefaultDescription(problem);
        error.setActivityId(id);
        this.addError(validationErrors, error);
    }
}

