/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.Collection;
import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Signal;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ValidatorImpl;
import org.apache.commons.lang3.StringUtils;

public class SignalValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        Collection signals = bpmnModel.getSignals();
        if (signals != null && !signals.isEmpty()) {
            for (Signal signal : signals) {
                if (StringUtils.isEmpty((CharSequence)signal.getId())) {
                    this.addError(errors, "SIGNAL_MISSING_ID", (BaseElement)signal);
                }
                if (StringUtils.isEmpty((CharSequence)signal.getName())) {
                    this.addError(errors, "SIGNAL_MISSING_NAME", (BaseElement)signal);
                }
                if (!StringUtils.isEmpty((CharSequence)signal.getName()) && this.duplicateName(signals, signal.getId(), signal.getName())) {
                    this.addError(errors, "SIGNAL_DUPLICATE_NAME", (BaseElement)signal);
                }
                if (signal.getScope() == null || signal.getScope().equals("global") || signal.getScope().equals("processInstance")) continue;
                this.addError(errors, "SIGNAL_INVALID_SCOPE", (BaseElement)signal);
            }
        }
    }

    protected boolean duplicateName(Collection<Signal> signals, String id, String name) {
        for (Signal signal : signals) {
            if (id == null || signal.getId() == null || !name.equals(signal.getName()) || id.equals(signal.getId())) continue;
            return true;
        }
        return false;
    }
}

