/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.LinkEventDefinition;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List events = process.findFlowElementsOfType(Event.class);
        for (Event event : events) {
            if (event.getEventDefinitions() == null) continue;
            for (EventDefinition eventDefinition : event.getEventDefinitions()) {
                if (eventDefinition instanceof MessageEventDefinition) {
                    this.handleMessageEventDefinition(bpmnModel, process, event, eventDefinition, errors);
                    continue;
                }
                if (eventDefinition instanceof SignalEventDefinition) {
                    this.handleSignalEventDefinition(bpmnModel, process, event, eventDefinition, errors);
                    continue;
                }
                if (eventDefinition instanceof TimerEventDefinition) {
                    this.handleTimerEventDefinition(process, event, eventDefinition, errors);
                    continue;
                }
                if (eventDefinition instanceof CompensateEventDefinition) {
                    this.handleCompensationEventDefinition(bpmnModel, process, event, eventDefinition, errors);
                    continue;
                }
                if (!(eventDefinition instanceof LinkEventDefinition)) continue;
                LinkEventDefinition linkEventDefinition = (LinkEventDefinition)eventDefinition;
                this.handleLinkEventDefinition(process, event, linkEventDefinition, errors);
            }
        }
    }

    protected void handleMessageEventDefinition(BpmnModel bpmnModel, Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
        if (StringUtils.isEmpty((CharSequence)messageEventDefinition.getMessageRef())) {
            if (StringUtils.isEmpty((CharSequence)messageEventDefinition.getMessageExpression())) {
                this.addError(errors, "MESSAGE_EVENT_MISSING_MESSAGE_REF", process, (BaseElement)event);
            }
        } else if (!bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
            this.addError(errors, "MESSAGE_EVENT_INVALID_MESSAGE_REF", process, (BaseElement)event);
        }
    }

    protected void handleSignalEventDefinition(BpmnModel bpmnModel, Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
        if (StringUtils.isEmpty((CharSequence)signalEventDefinition.getSignalRef())) {
            if (StringUtils.isEmpty((CharSequence)signalEventDefinition.getSignalExpression())) {
                this.addError(errors, "SIGNAL_EVENT_MISSING_SIGNAL_REF", process, (BaseElement)event);
            }
        } else if (!bpmnModel.containsSignalId(signalEventDefinition.getSignalRef())) {
            this.addError(errors, "SIGNAL_EVENT_INVALID_SIGNAL_REF", process, (BaseElement)event);
        }
    }

    protected void handleTimerEventDefinition(Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition;
        if (StringUtils.isEmpty((CharSequence)timerEventDefinition.getTimeDate()) && StringUtils.isEmpty((CharSequence)timerEventDefinition.getTimeCycle()) && StringUtils.isEmpty((CharSequence)timerEventDefinition.getTimeDuration())) {
            this.addError(errors, "EVENT_TIMER_MISSING_CONFIGURATION", process, (BaseElement)event);
        }
    }

    protected void handleCompensationEventDefinition(BpmnModel bpmnModel, Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        CompensateEventDefinition compensateEventDefinition = (CompensateEventDefinition)eventDefinition;
        if (StringUtils.isNotEmpty((CharSequence)compensateEventDefinition.getActivityRef()) && process.getFlowElement(compensateEventDefinition.getActivityRef(), true) == null) {
            this.addError(errors, "COMPENSATE_EVENT_INVALID_ACTIVITY_REF", process, (BaseElement)event);
        }
    }

    private void handleLinkEventDefinition(Process process, Event event, LinkEventDefinition linkEventDefinition, List<ValidationError> errors) {
        HashMap<String, String> params;
        if (event.isLinkThrowEvent() && StringUtils.isEmpty((CharSequence)linkEventDefinition.getTarget())) {
            params = new HashMap<String, String>();
            params.put("eventId", event.getId());
            if (StringUtils.isNotEmpty((CharSequence)event.getName())) {
                params.put("eventName", event.getName());
                this.addError(errors, "LINK_EVENT_DEFINITION_MISSING_TARGET", process, (BaseElement)event, params);
            } else {
                this.addError(errors, "LINK_EVENT_DEFINITION_MISSING_TARGET_EMPTY_NAME", process, (BaseElement)event, params);
            }
        }
        if (event.isLinkCatchEvent() && CollectionUtils.isEmpty((Collection)linkEventDefinition.getSources())) {
            params = new HashMap();
            params.put("eventId", event.getId());
            if (StringUtils.isNotEmpty((CharSequence)event.getName())) {
                params.put("eventName", event.getName());
                this.addError(errors, "LINK_EVENT_DEFINITION_MISSING_SOURCE", process, (BaseElement)event, params);
            } else {
                this.addError(errors, "LINK_EVENT_DEFINITION_MISSING_SOURCE_EMPTY_NAME", process, (BaseElement)event, params);
            }
        }
    }
}

