/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.resolver;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import org.activiti.spring.resolver.EnvVar;

public class EnvironmentVariableELResolver
extends ELResolver {
    private static final String VAR_PREFIX = "vars";
    public static final String VAR_PREFIX_WITH_DOT = "vars.";

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null && VAR_PREFIX.equals(property)) {
            context.setPropertyResolved(true);
            return new EnvVar();
        }
        if (base instanceof EnvVar && property != null) {
            String env = System.getenv(VAR_PREFIX_WITH_DOT + String.valueOf(property));
            context.setPropertyResolved(true);
            return env;
        }
        return null;
    }

    public Class<?> getType(ELContext elContext, Object o, Object o1) {
        return String.class;
    }

    public void setValue(ELContext elContext, Object o, Object o1, Object o2) {
        throw new UnsupportedOperationException("Environment variables are read-only");
    }

    public boolean isReadOnly(ELContext elContext, Object o, Object o1) {
        return true;
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object o) {
        return String.class;
    }
}

