/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.resolver;

import jakarta.el.ELResolver;
import java.util.List;
import org.activiti.spring.boot.ProcessEngineConfigurationConfigurer;
import org.activiti.spring.resolver.EnvironmentVariableELResolver;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class ELResolverAutoConfiguration {
    @ConditionalOnProperty(name={"spring.activiti.env-var-el-resolver.enabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    public EnvironmentVariableELResolver environmentVariableELResolver() {
        return new EnvironmentVariableELResolver();
    }

    @Bean
    public ProcessEngineConfigurationConfigurer environmentVariablesELResolverConfigurer(List<ELResolver> customELResolvers) {
        return processEngineConfiguration -> {
            if (customELResolvers != null) {
                processEngineConfiguration.setCustomELResolvers(customELResolvers);
            }
        };
    }
}

