/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.api.process.model.ProcessDefinition;
import org.activiti.api.process.model.StartMessageDeploymentDefinition;
import org.activiti.api.process.model.StartMessageSubscription;
import org.activiti.api.process.model.events.StartMessageDeployedEvent;
import org.activiti.api.process.runtime.events.listener.ProcessRuntimeEventListener;
import org.activiti.api.runtime.event.impl.StartMessageDeployedEventImpl;
import org.activiti.api.runtime.event.impl.StartMessageDeployedEvents;
import org.activiti.api.runtime.model.impl.StartMessageDeploymentDefinitionImpl;
import org.activiti.engine.ManagementService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.EventSubscriptionQueryImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.runtime.api.event.impl.StartMessageSubscriptionConverter;
import org.activiti.runtime.api.model.impl.APIProcessDefinitionConverter;
import org.activiti.spring.AbstractActivitiSmartLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class StartMessageDeployedEventProducer
extends AbstractActivitiSmartLifeCycle {
    private static Logger logger = LoggerFactory.getLogger(StartMessageDeployedEventProducer.class);
    private RepositoryService repositoryService;
    private ManagementService managementService;
    private APIProcessDefinitionConverter converter;
    private StartMessageSubscriptionConverter subscriptionConverter;
    private List<ProcessRuntimeEventListener<StartMessageDeployedEvent>> listeners;
    private ApplicationEventPublisher eventPublisher;

    public StartMessageDeployedEventProducer(RepositoryService repositoryService, ManagementService managementService, StartMessageSubscriptionConverter subscriptionConverter, APIProcessDefinitionConverter converter, List<ProcessRuntimeEventListener<StartMessageDeployedEvent>> listeners, ApplicationEventPublisher eventPublisher) {
        this.repositoryService = repositoryService;
        this.managementService = managementService;
        this.subscriptionConverter = subscriptionConverter;
        this.converter = converter;
        this.listeners = listeners;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void doStart() {
        List processDefinitions = this.converter.from((Collection)this.repositoryService.createProcessDefinitionQuery().list());
        ArrayList<StartMessageDeployedEvent> messageDeployedEvents = new ArrayList<StartMessageDeployedEvent>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            ((List)this.managementService.executeCommand((Command)new FindStartMessageEventSubscriptions(processDefinition.getId()))).stream().map(arg_0 -> ((StartMessageSubscriptionConverter)this.subscriptionConverter).convertToStartMessageSubscription(arg_0)).map(messageSubscription -> StartMessageDeploymentDefinitionImpl.builder().withMessageSubscription((StartMessageSubscription)messageSubscription).withProcessDefinition(processDefinition).build()).map(startMessageDeploymentDefinition -> StartMessageDeployedEventImpl.builder().withEntity((StartMessageDeploymentDefinition)startMessageDeploymentDefinition).build()).forEach(messageDeployedEvents::add);
        }
        this.managementService.executeCommand((Command)new DispatchStartMessageDeployedEvents(messageDeployedEvents));
        if (!messageDeployedEvents.isEmpty()) {
            this.eventPublisher.publishEvent((ApplicationEvent)new StartMessageDeployedEvents(messageDeployedEvents));
        }
    }

    @Override
    public void doStop() {
    }

    static class FindStartMessageEventSubscriptions
    implements Command<List<MessageEventSubscriptionEntity>> {
        private static final String MESSAGE = "message";
        private final String processDefinitionId;

        public FindStartMessageEventSubscriptions(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
        }

        public List<MessageEventSubscriptionEntity> execute(CommandContext commandContext) {
            return new EventSubscriptionQueryImpl(commandContext).eventType(MESSAGE).configuration(this.processDefinitionId).list().stream().map(MessageEventSubscriptionEntity.class::cast).filter(it -> it.getProcessInstanceId() == null).collect(Collectors.toList());
        }
    }

    class DispatchStartMessageDeployedEvents
    implements Command<Void> {
        private final List<StartMessageDeployedEvent> messageDeployedEvents;

        public DispatchStartMessageDeployedEvents(List<StartMessageDeployedEvent> messageDeployedEvents) {
            this.messageDeployedEvents = messageDeployedEvents;
        }

        public Void execute(CommandContext commandContext) {
            for (ProcessRuntimeEventListener<StartMessageDeployedEvent> listener : StartMessageDeployedEventProducer.this.listeners) {
                this.messageDeployedEvents.stream().forEach(arg_0 -> listener.onEvent(arg_0));
            }
            return null;
        }
    }
}

