/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import java.util.Optional;
import org.activiti.core.common.model.connector.VariableDefinition;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.spring.process.ProcessExtensionRepository;
import org.activiti.spring.process.model.Extension;
import org.activiti.spring.process.model.ProcessVariablesMapping;
import org.springframework.lang.NonNull;

public class ProcessExtensionService {
    private static final Extension EMPTY_EXTENSION = new Extension();
    private final ProcessExtensionRepository processExtensionRepository;

    public ProcessExtensionService(ProcessExtensionRepository processExtensionRepository) {
        this.processExtensionRepository = processExtensionRepository;
    }

    public boolean hasExtensionsFor(@NonNull ProcessDefinition processDefinition) {
        return this.hasExtensionsFor(processDefinition.getId());
    }

    public boolean hasExtensionsFor(@NonNull String processDefinitionId) {
        return this.processExtensionRepository.getExtensionsForId(processDefinitionId).isPresent();
    }

    public Extension getExtensionsFor(@NonNull ProcessDefinition processDefinition) {
        return this.getExtensionsForId(processDefinition.getId());
    }

    public Extension getExtensionsForId(@NonNull String processDefinitionId) {
        return this.processExtensionRepository.getExtensionsForId(processDefinitionId).orElse(EMPTY_EXTENSION);
    }

    public boolean hasEphemeralVariable(String processDefinitionId, @NonNull String variableName) {
        if (processDefinitionId == null) {
            return false;
        }
        Extension extension = this.getExtensionsForId(processDefinitionId);
        return Optional.ofNullable(extension).map(ext -> ext.getPropertyByName(variableName)).map(VariableDefinition::isEphemeral).orElse(false);
    }

    public boolean isTaskMappingEphemeral(String processDefinitionId, String taskDefinitionKey) {
        Extension extension = this.getExtensionsForId(processDefinitionId);
        ProcessVariablesMapping mapping = extension.getMappings() != null ? extension.getMappings().get(taskDefinitionKey) : null;
        return mapping != null && mapping.isEphemeral();
    }
}

