/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import java.util.Optional;
import org.activiti.spring.process.ProcessExtensionRepository;
import org.activiti.spring.process.model.Extension;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.lang.NonNull;

@CacheConfig(cacheNames={"processExtensionsById"})
public class CacheableProcessExtensionRepository
implements ProcessExtensionRepository {
    public static final String PROCESS_EXTENSIONS_CACHE_NAME = "processExtensionsById";
    private final ProcessExtensionRepository delegate;

    public CacheableProcessExtensionRepository(ProcessExtensionRepository delegate) {
        this.delegate = delegate;
    }

    @Override
    @Cacheable
    public Optional<Extension> getExtensionsForId(@NonNull String processDefinitionId) {
        return this.delegate.getExtensionsForId(processDefinitionId);
    }
}

