/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.activiti.spring.process.model.AssignmentDefinition;
import org.activiti.spring.process.model.ProcessConstantsMapping;
import org.activiti.spring.process.model.ProcessVariablesMapping;
import org.activiti.spring.process.model.TemplateDefinition;
import org.activiti.spring.process.model.TemplatesDefinition;
import org.activiti.spring.process.model.VariableDefinition;

public class Extension {
    private static final ProcessVariablesMapping EMPTY_PROCESS_VARIABLES_MAPPING = new ProcessVariablesMapping();
    private Map<String, VariableDefinition> properties = new HashMap<String, VariableDefinition>();
    private Map<String, ProcessVariablesMapping> mappings = new HashMap<String, ProcessVariablesMapping>();
    private Map<String, ProcessConstantsMapping> constants = new HashMap<String, ProcessConstantsMapping>();
    private TemplatesDefinition templates = new TemplatesDefinition();
    private Map<String, AssignmentDefinition> assignments = new HashMap<String, AssignmentDefinition>();

    public Map<String, VariableDefinition> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, VariableDefinition> properties) {
        this.properties = properties;
    }

    public Map<String, ProcessVariablesMapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, ProcessVariablesMapping> mappings) {
        this.mappings = mappings;
    }

    public Map<String, ProcessConstantsMapping> getConstants() {
        return this.constants;
    }

    public void setConstants(Map<String, ProcessConstantsMapping> constants) {
        this.constants = constants;
    }

    public ProcessConstantsMapping getConstantForFlowElement(String flowElementUUID) {
        ProcessConstantsMapping processConstantsMapping = this.constants.get(flowElementUUID);
        return processConstantsMapping != null ? processConstantsMapping : new ProcessConstantsMapping();
    }

    public ProcessVariablesMapping getMappingForFlowElement(String flowElementUUID) {
        ProcessVariablesMapping processVariablesMapping = this.mappings.get(flowElementUUID);
        return processVariablesMapping != null ? processVariablesMapping : EMPTY_PROCESS_VARIABLES_MAPPING;
    }

    public Optional<TemplateDefinition> findAssigneeTemplateForTask(String taskUUID) {
        return this.templates.findAssigneeTemplateForTask(taskUUID);
    }

    public Optional<TemplateDefinition> findCandidateTemplateForTask(String taskUUID) {
        return this.templates.findCandidateTemplateForTask(taskUUID);
    }

    public VariableDefinition getProperty(String propertyUUID) {
        return this.properties != null ? this.properties.get(propertyUUID) : null;
    }

    public VariableDefinition getPropertyByName(String name) {
        if (this.properties != null) {
            for (Map.Entry<String, VariableDefinition> variableDefinition : this.properties.entrySet()) {
                if (variableDefinition.getValue() == null || !Objects.equals(variableDefinition.getValue().getName(), name)) continue;
                return variableDefinition.getValue();
            }
        }
        return null;
    }

    public boolean hasMapping(String taskId) {
        return this.mappings.get(taskId) != null;
    }

    public boolean shouldMapAllInputs(String elementId) {
        ProcessVariablesMapping processVariablesMapping = this.mappings.get(elementId);
        return processVariablesMapping.getMappingType() != null && (processVariablesMapping.getMappingType().equals((Object)ProcessVariablesMapping.MappingType.MAP_ALL_INPUTS) || processVariablesMapping.getMappingType().equals((Object)ProcessVariablesMapping.MappingType.MAP_ALL));
    }

    public boolean shouldMapAllOutputs(String elementId) {
        ProcessVariablesMapping processVariablesMapping = this.mappings.get(elementId);
        return processVariablesMapping.getMappingType() != null && (processVariablesMapping.getMappingType().equals((Object)ProcessVariablesMapping.MappingType.MAP_ALL_OUTPUTS) || processVariablesMapping.getMappingType().equals((Object)ProcessVariablesMapping.MappingType.MAP_ALL));
    }

    public TemplatesDefinition getTemplates() {
        return this.templates;
    }

    public void setTemplates(TemplatesDefinition templates) {
        this.templates = templates;
    }

    public Map<String, AssignmentDefinition> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(Map<String, AssignmentDefinition> assignments) {
        this.assignments = assignments;
    }
}

