/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.activiti.spring.process.model.TaskTemplateDefinition;
import org.activiti.spring.process.model.TemplateDefinition;

public class TemplatesDefinition {
    private Map<String, TaskTemplateDefinition> tasks = new HashMap<String, TaskTemplateDefinition>();
    @JsonProperty(value="default")
    private TaskTemplateDefinition defaultTemplate;

    public Map<String, TaskTemplateDefinition> getTasks() {
        return this.tasks;
    }

    public void setTasks(Map<String, TaskTemplateDefinition> tasks) {
        this.tasks = tasks;
    }

    public TaskTemplateDefinition getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public void setDefaultTemplate(TaskTemplateDefinition defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    public Optional<TemplateDefinition> findAssigneeTemplateForTask(String taskUUID) {
        TaskTemplateDefinition taskTemplateDefinition = this.tasks.get(taskUUID);
        if (taskTemplateDefinition == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(taskTemplateDefinition.getAssignee());
    }

    public Optional<TemplateDefinition> findCandidateTemplateForTask(String taskUUID) {
        TaskTemplateDefinition taskTemplateDefinition = this.tasks.get(taskUUID);
        if (taskTemplateDefinition == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(taskTemplateDefinition.getCandidate());
    }

    public boolean isEmailNotificationEnabledForTask(String taskUUID) {
        TaskTemplateDefinition taskTemplateDefinition = this.tasks.get(taskUUID);
        if (taskTemplateDefinition == null) {
            return true;
        }
        return taskTemplateDefinition.isEmailNotificationEnabled();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplatesDefinition that = (TemplatesDefinition)o;
        return Objects.equals(this.tasks, that.tasks) && Objects.equals(this.defaultTemplate, that.defaultTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.tasks, this.defaultTemplate);
    }
}

