/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process.variable.types;

import java.math.BigDecimal;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.spring.process.variable.types.VariableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigDecimalVariableType
extends VariableType {
    public static final String VALIDATION_ERROR_FORMAT = "%s is not a numeric type";
    private static final Logger logger = LoggerFactory.getLogger(BigDecimalVariableType.class);

    @Override
    public Object parseFromValue(Object value) throws ActivitiException {
        if (value instanceof BigDecimal) {
            return value;
        }
        try {
            if (value instanceof String) {
                return new BigDecimal((String)value);
            }
            return BigDecimal.valueOf(((Number)value).doubleValue());
        }
        catch (ClassCastException | NumberFormatException e) {
            throw new ActivitiException("Error parsing bigdecimal value from " + String.valueOf(value) + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void validate(Object var, List<ActivitiException> errors) {
        if (!Number.class.isAssignableFrom(var.getClass())) {
            String message = String.format(VALIDATION_ERROR_FORMAT, var.getClass());
            errors.add(new ActivitiException(message));
            logger.error(message);
        }
    }
}

