/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.resources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.spring.resources.ResourceFinderDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ResourceFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFinder.class);
    private ResourcePatternResolver resourceLoader;

    public ResourceFinder(ResourcePatternResolver resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public List<Resource> discoverResources(ResourceFinderDescriptor resourceFinderDescriptor) throws IOException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (resourceFinderDescriptor.shouldLookUpResources()) {
            for (String suffix : resourceFinderDescriptor.getLocationSuffixes()) {
                String path = resourceFinderDescriptor.getLocationPrefix() + suffix;
                resources.addAll(Arrays.asList(this.resourceLoader.getResources(path)));
            }
            if (resources.isEmpty()) {
                LOGGER.info(resourceFinderDescriptor.getMsgForEmptyResources());
            } else {
                resourceFinderDescriptor.validate(resources);
                List<String> foundResources = resources.stream().map(Resource::getFilename).collect(Collectors.toList());
                LOGGER.info(resourceFinderDescriptor.getMsgForResourcesFound(foundResources));
            }
        }
        return resources;
    }
}

