/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.autodeployment;

import org.activiti.core.common.spring.project.ApplicationUpgradeContextService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.springframework.core.io.Resource;

public class DefaultAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    public static final String DEPLOYMENT_MODE = "default";

    public DefaultAutoDeploymentStrategy(ApplicationUpgradeContextService applicationUpgradeContextService) {
        super(applicationUpgradeContextService);
    }

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, RepositoryService repositoryService) {
        DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(deploymentNameHint);
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            deploymentBuilder.addInputStream(resourceName, resource);
        }
        this.loadApplicationUpgradeContext(deploymentBuilder).deploy();
    }
}

