/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.acc.shared.rest.httpclient;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.activiti.cloud.acc.shared.model.AuthToken;
import org.activiti.cloud.acc.shared.rest.httpclient.Serializer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.assertj.core.api.Assertions;

public class ConnectorHelper {
    private static CloseableHttpClient connect() {
        return HttpClients.createDefault();
    }

    private static Header[] headers(String authToken) {
        return new Header[]{new BasicHeader("Content-Type", "application/json"), new BasicHeader("Authorization", "Bearer " + authToken)};
    }

    public static String get(String url, Map<String, String> params, AuthToken authToken) throws URISyntaxException, IOException {
        CloseableHttpClient client = ConnectorHelper.connect();
        URIBuilder builder = new URIBuilder(url);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        HttpGet httpGet = new HttpGet(builder.build());
        httpGet.setHeaders(ConnectorHelper.headers(authToken.getAccess_token()));
        CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpGet);
        Assertions.assertThat((int)httpResponse.getStatusLine().getStatusCode()).isEqualTo(200);
        String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        ConnectorHelper.close(client, httpResponse);
        return responseBody;
    }

    public static String postJson(String url, Object object, AuthToken authToken) throws IOException {
        CloseableHttpClient client = ConnectorHelper.connect();
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(Serializer.toJsonString(object));
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeaders(ConnectorHelper.headers(authToken.getAccess_token()));
        CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
        Assertions.assertThat((int)httpResponse.getStatusLine().getStatusCode()).isEqualTo(200);
        String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        ConnectorHelper.close(client, httpResponse);
        return responseBody;
    }

    public static String postForm(String url, Map<String, String> form, AuthToken authToken) throws IOException {
        CloseableHttpClient client = ConnectorHelper.connect();
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : form.entrySet()) {
            postParameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
        if (authToken != null) {
            httpPost.setHeaders(ConnectorHelper.headers(authToken.getAccess_token()));
        }
        CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
        Assertions.assertThat((int)httpResponse.getStatusLine().getStatusCode()).isEqualTo(200);
        String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        ConnectorHelper.close(client, httpResponse);
        return responseBody;
    }

    private static void close(CloseableHttpClient closeableHttpClient, CloseableHttpResponse closeableHttpResponse) {
        if (closeableHttpResponse != null) {
            try {
                closeableHttpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            closeableHttpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

