/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.acc.shared.rest.feign;

import feign.Body;
import feign.Feign;
import feign.Headers;
import feign.Logger;
import feign.Param;
import feign.RequestInterceptor;
import feign.RequestLine;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonEncoder;
import java.util.List;
import org.activiti.cloud.acc.shared.rest.feign.FeignErrorDecoder;
import org.activiti.cloud.acc.shared.rest.feign.HalDecoder;
import org.activiti.cloud.acc.shared.rest.feign.OAuth2FeignRequestInterceptor;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;

public interface FeignRestDataClient<C extends FeignRestDataClient, R> {
    @RequestLine(value="POST")
    @Headers(value={"Content-Type: application/json"})
    public EntityModel<R> create(R var1);

    @RequestLine(value="GET /{id}")
    @Headers(value={"Content-Type: application/json"})
    public EntityModel<R> findById(@Param(value="id") String var1);

    @RequestLine(value="GET")
    @Headers(value={"Content-Type: application/json"})
    public PagedModel<EntityModel<R>> findAll();

    @RequestLine(value="PUT /{id}")
    @Headers(value={"Content-Type: application/json"})
    public void updateById(@Param(value="id") String var1, R var2);

    @RequestLine(value="PUT")
    @Headers(value={"Content-Type: application/json"})
    public void update(R var1);

    @RequestLine(value="PUT")
    @Headers(value={"Content-Type: text/uri-list"})
    @Body(value="{uriList}")
    public void addRelation(@Param(value="uriList") String var1);

    @RequestLine(value="PUT")
    @Headers(value={"Content-Type: text/uri-list"})
    @Body(value="{uriList}")
    public void addRelation(@Param(value="uriList") List<String> var1);

    @RequestLine(value="GET")
    @Headers(value={"Content-Type: application/json"})
    public EntityModel<R> get();

    @RequestLine(value="DELETE")
    @Headers(value={"Content-Type: application/json"})
    public void delete();

    public Class<C> getType();

    default public PagedModel<EntityModel<R>> findAllByUri(String uri) {
        return this.buildByUri(uri).findAll();
    }

    default public EntityModel<R> findByUri(String uri) {
        return this.buildByUri(uri).get();
    }

    default public EntityModel<R> createByUri(String uri, R resource) {
        return this.buildByUri(uri).create(resource);
    }

    default public void updateByUri(String uri, R resource) {
        this.buildByUri(uri).update(resource);
    }

    default public void deleteByUri(String uri) {
        this.buildByUri(uri).delete();
    }

    default public C buildByUri(String uri) {
        return (C)((FeignRestDataClient)this.builder().target(this.getType(), uri));
    }

    default public Encoder encoder() {
        return new GsonEncoder();
    }

    default public Decoder decoder() {
        return new HalDecoder();
    }

    default public Feign.Builder builder() {
        return FeignRestDataClient.builder(this.encoder(), this.decoder());
    }

    public static Feign.Builder builder(Encoder encoder, Decoder decoder) {
        return Feign.builder().encoder(encoder).decoder(decoder).errorDecoder((ErrorDecoder)new FeignErrorDecoder()).logger((Logger)new Logger.ErrorLogger()).logLevel(Logger.Level.BASIC).requestInterceptor((RequestInterceptor)new OAuth2FeignRequestInterceptor());
    }
}

