/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.api.process.model.impl.events;

import java.util.List;
import java.util.Objects;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.process.model.events.IntegrationEvent;
import org.activiti.cloud.api.process.model.events.CloudIntegrationErrorReceivedEvent;
import org.activiti.cloud.api.process.model.impl.events.CloudIntegrationEventImpl;

public class CloudIntegrationErrorReceivedEventImpl
extends CloudIntegrationEventImpl
implements CloudIntegrationErrorReceivedEvent {
    private static final long serialVersionUID = 1L;
    private String errorCode;
    private String errorMessage;
    private String errorClassName;
    private List<StackTraceElement> stackTraceElements;

    public CloudIntegrationErrorReceivedEventImpl() {
    }

    public CloudIntegrationErrorReceivedEventImpl(IntegrationContext integrationContext, String errorCode, String errorMessage, String errorClassName, List<StackTraceElement> stackTraceElements) {
        super(integrationContext);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.errorClassName = errorClassName;
        this.stackTraceElements = stackTraceElements;
    }

    public CloudIntegrationErrorReceivedEventImpl(String id, Long timestamp, IntegrationContext integrationContext, String errorCode, String errorMessage, String errorClassName, List<StackTraceElement> stackTraceElements) {
        super(id, timestamp, integrationContext);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.errorClassName = errorClassName;
        this.stackTraceElements = stackTraceElements;
    }

    public IntegrationEvent.IntegrationEvents getEventType() {
        return IntegrationEvent.IntegrationEvents.INTEGRATION_ERROR_RECEIVED;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorClassName() {
        return this.errorClassName;
    }

    public List<StackTraceElement> getStackTraceElements() {
        return this.stackTraceElements;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.errorClassName, this.errorCode, this.errorMessage, this.stackTraceElements);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CloudIntegrationErrorReceivedEventImpl other = (CloudIntegrationErrorReceivedEventImpl)((Object)obj);
        return Objects.equals(this.errorClassName, other.errorClassName) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.stackTraceElements, other.stackTraceElements);
    }

    public String toString() {
        int maxLen = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("CloudIntegrationErrorReceivedEventImpl [errorCode=").append(this.errorCode).append(", errorMessage=").append(this.errorMessage).append(", errorClassName=").append(this.errorClassName).append(", stackTraceElements=").append(this.stackTraceElements != null ? this.stackTraceElements.subList(0, Math.min(this.stackTraceElements.size(), 10)) : null).append(", toString()=").append(super.toString()).append("]");
        return builder.toString();
    }
}

