/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.api.process.model.impl;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.activiti.api.model.shared.Payload;

public class SyncCloudProcessDefinitionsPayload
implements Payload {
    private final String id = UUID.randomUUID().toString();
    private List<String> processDefinitionKeys;
    private List<String> excludedProcessDefinitionIds;

    public String getId() {
        return this.id;
    }

    public List<String> getProcessDefinitionKeys() {
        return this.processDefinitionKeys;
    }

    public List<String> getExcludedProcessDefinitionIds() {
        return this.excludedProcessDefinitionIds;
    }

    public void setProcessDefinitionKeys(List<String> processDefinitionKeys) {
        this.processDefinitionKeys = List.copyOf(processDefinitionKeys);
    }

    public void setExcludedProcessDefinitionIds(List<String> excludedProcessDefinitionIds) {
        this.excludedProcessDefinitionIds = List.copyOf(excludedProcessDefinitionIds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyncCloudProcessDefinitionsPayload)) {
            return false;
        }
        SyncCloudProcessDefinitionsPayload that = (SyncCloudProcessDefinitionsPayload)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.processDefinitionKeys, that.processDefinitionKeys) && Objects.equals(this.excludedProcessDefinitionIds, that.excludedProcessDefinitionIds);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SyncCloudProcessDefinitionsPayload payload) {
        return new Builder(payload);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.processDefinitionKeys, this.excludedProcessDefinitionIds);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SyncCloudProcessDefinitionsPayload{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", processDefinitionKeys=").append(this.processDefinitionKeys);
        sb.append(", excludedProcessDefinitionIds=").append(this.excludedProcessDefinitionIds);
        sb.append('}');
        return sb.toString();
    }

    public static final class Builder {
        private List<String> processDefinitionKeys;
        private List<String> excludedProcessDefinitionIds;

        public Builder() {
        }

        public Builder(SyncCloudProcessDefinitionsPayload other) {
            this.processDefinitionKeys = other.processDefinitionKeys;
            this.excludedProcessDefinitionIds = other.excludedProcessDefinitionIds;
        }

        public Builder processDefinitionKeys(List<String> processDefinitionKeys) {
            this.processDefinitionKeys = List.copyOf(processDefinitionKeys);
            return this;
        }

        public Builder excludedProcessDefinitionIds(List<String> excludedProcessDefinitionIds) {
            this.excludedProcessDefinitionIds = List.copyOf(excludedProcessDefinitionIds);
            return this;
        }

        public SyncCloudProcessDefinitionsPayload build() {
            SyncCloudProcessDefinitionsPayload syncCloudProcessDefinitionsPayload = new SyncCloudProcessDefinitionsPayload();
            syncCloudProcessDefinitionsPayload.excludedProcessDefinitionIds = this.excludedProcessDefinitionIds;
            syncCloudProcessDefinitionsPayload.processDefinitionKeys = this.processDefinitionKeys;
            return syncCloudProcessDefinitionsPayload;
        }
    }
}

