/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.api.process.model.impl.events;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.process.model.CloudBpmnError;
import org.activiti.cloud.api.process.model.IncidentContext;
import org.activiti.cloud.api.process.model.IncidentEvent;

public class CloudIncidentCreatedEventImpl
extends CloudRuntimeEventImpl<IncidentContext, IncidentEvent.IncidentEventType>
implements IncidentEvent {
    private String errorCode;
    private String errorMessage;
    private List<StackTraceElement> stackTraceElements;
    private String errorClassName;

    public CloudIncidentCreatedEventImpl() {
    }

    public CloudIncidentCreatedEventImpl(Throwable error, IncidentContext incidentContext) {
        super((Object)incidentContext);
        this.errorClassName = error.getClass().getName();
        this.errorCode = Optional.of(error).filter(CloudBpmnError.class::isInstance).map(CloudBpmnError.class::cast).map(CloudBpmnError::getErrorCode).orElse(null);
        Throwable cause = this.findRootCause(error);
        this.errorMessage = cause.getMessage();
        this.stackTraceElements = Arrays.asList(cause.getStackTrace());
        this.setEntityId(incidentContext.getExecutionId());
    }

    public CloudIncidentCreatedEventImpl(String id, Long timestamp, IncidentContext entity, String errorClassName, String errorCode, String errorMessage, List<StackTraceElement> stackTraceElements) {
        super(id, timestamp, (Object)entity);
        this.errorClassName = errorClassName;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.stackTraceElements = stackTraceElements;
    }

    public IncidentEvent.IncidentEventType getEventType() {
        return IncidentEvent.IncidentEventType.INCIDENT_CREATED;
    }

    public List<StackTraceElement> getStackTraceElements() {
        return this.stackTraceElements;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorClassName() {
        return this.errorClassName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    protected Throwable findRootCause(Throwable throwable) {
        Throwable rootCause;
        for (rootCause = Objects.requireNonNull(throwable); rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }
}

